/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins.jar;

import java.net.URI;
import java.util.jar.Attributes;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginVersion;

public class ManifestReader {
    private static final String PLUGIN_URL = "Plugin-Url";
    private static final String PLUGIN_ICON = "Plugin-Icon";
    private static final String PLUGIN_OS = "Plugin-Os";
    private static final String ENTRY_ATTRIBUTES_IS_EMPTY = "Entry attributes is empty";
    private static final String ATTRIBUTES_IS_NULL = "Attributes is null";
    private static final String ENTRY_NAME_IS_NULL = "Entry name is null";
    private static final String JAR_URI_IS_NULL = "Jar URI is null";
    private static final String NOT_DEFINED_FOR_PLUGIN = " not defined for plugin ";
    private static final String PLUGIN_VERSION = "Plugin-Version";
    private static final String PLUGIN_CLASS = "Plugin-Class";
    private static final String PLUGIN_AUTHOR = "Plugin-Author";

    public void validateManifestEntry(URI jarURI, String entryName, Attributes entryAttributes) throws PluginSystemException {
        if (jarURI == null) {
            throw new IllegalArgumentException(JAR_URI_IS_NULL);
        }
        if (entryName == null) {
            throw new IllegalArgumentException(ENTRY_NAME_IS_NULL);
        }
        if (entryAttributes == null) {
            throw new IllegalArgumentException(ATTRIBUTES_IS_NULL);
        }
        if (entryAttributes.isEmpty()) {
            throw new PluginSystemException(ENTRY_ATTRIBUTES_IS_EMPTY);
        }
        if (this.getPluginClass(entryAttributes) == null) {
            throw new PluginSystemException(PLUGIN_CLASS + NOT_DEFINED_FOR_PLUGIN + entryName);
        }
        if (this.getPluginAuthor(entryAttributes) == null) {
            throw new PluginSystemException(PLUGIN_AUTHOR + NOT_DEFINED_FOR_PLUGIN + entryName);
        }
        if (this.getPluginVersion(entryAttributes) == null) {
            throw new PluginSystemException(PLUGIN_VERSION + NOT_DEFINED_FOR_PLUGIN + entryName);
        }
        PluginVersion.getPluginVersion(this.getPluginVersion(entryAttributes));
    }

    public String getPluginAuthor(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_AUTHOR);
    }

    public String getPluginClass(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_CLASS);
    }

    public String getPluginVersion(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_VERSION);
    }

    public String getPluginOs(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_OS);
    }

    public String getPluginIcon(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_ICON);
    }

    public String getPluginUrl(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue(PLUGIN_URL);
    }
}

