/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static void unzipArchive(File archive, File outputDir) throws IOException {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipUtils.unzipEntry(zipfile, entry, outputDir);
            }
        }
        finally {
            if (zipfile != null) {
                zipfile.close();
            }
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            ZipUtils.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            ZipUtils.createDir(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static void createDir(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Can not create dir " + dir);
        }
    }
}

