/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.commonjukebox.plugins.PluginListeners;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.PluginsLoader;
import org.commonjukebox.plugins.classloader.ClassLoaderManager;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginRepositoryInformation;

class PluginFolderLoader {
    private ClassLoaderManager classLoaderManager;
    private PluginsLoader pluginsLoader;
    private PluginListeners pluginListeners;

    PluginFolderLoader(ClassLoaderManager classLoaderManager, PluginsLoader pluginsLoader, PluginListeners pluginListeners) {
        this.classLoaderManager = classLoaderManager;
        this.pluginsLoader = pluginsLoader;
        this.pluginListeners = pluginListeners;
    }

    protected Map<PluginFolder, PluginSystemException> loadPluginFolders(PluginRepositoryInformation pri, Collection<PluginFolder> pluginFolders) throws PluginSystemException {
        HashMap<PluginFolder, PluginSystemException> exceptionsLoadingPlugins = new HashMap<PluginFolder, PluginSystemException>();
        HashSet<PluginFolder> activePlugins = new HashSet<PluginFolder>();
        for (PluginFolder pluginFolder : pluginFolders) {
            try {
                if (!this.pluginsLoader.loadPlugin(pri, pluginFolder)) continue;
                activePlugins.add(pluginFolder);
            }
            catch (PluginSystemException e) {
                pri.removePluginFolder(pluginFolder);
                exceptionsLoadingPlugins.put(pluginFolder, e);
                StringBuilder error = new StringBuilder().append("Folder ").append(pluginFolder.getName()).append(" could not be loaded due to: ").append(e.getMessage());
                PluginSystemLogger.getLogger().info(error.toString());
            }
        }
        this.classLoaderManager.addToClassLoader(activePlugins);
        this.pluginListeners.callListenersForActivePlugin(activePlugins);
        return exceptionsLoadingPlugins;
    }

    protected void unloadPluginFolders(Collection<PluginFolder> pluginFolders) throws PluginSystemException {
        ArrayList<PluginInfo> pluginsToDeactivate = new ArrayList<PluginInfo>();
        for (PluginFolder pluginFolder : pluginFolders) {
            PluginInfo pluginInfo = pluginFolder.getPluginInfo();
            if (!pluginInfo.isActive()) continue;
            pluginsToDeactivate.add(pluginInfo);
        }
        this.pluginListeners.callListenersForInactivePlugin(pluginsToDeactivate);
        this.classLoaderManager.removeFromClassLoader(pluginFolders);
    }
}

