/*
 * Decompiled with CFR 0.152.
 */
package org.commonjukebox.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import org.commonjukebox.plugins.PluginSystemLogger;
import org.commonjukebox.plugins.exceptions.MoreThanOnePluginPerFolderException;
import org.commonjukebox.plugins.exceptions.PluginSystemException;
import org.commonjukebox.plugins.jar.JarUtils;
import org.commonjukebox.plugins.jar.ManifestReader;
import org.commonjukebox.plugins.model.PluginFolder;
import org.commonjukebox.plugins.model.PluginInfo;
import org.commonjukebox.plugins.model.PluginVersion;

class JarInfoReader {
    JarInfoReader() {
    }

    protected PluginInfo getPluginInFolder(PluginFolder pluginsFolder) throws PluginSystemException {
        ArrayList<PluginInfo> pluginsFound = new ArrayList<PluginInfo>();
        for (URI jar : pluginsFolder.getJars()) {
            pluginsFound.addAll(this.getPluginsInJar(jar));
        }
        if (pluginsFound.size() > 1) {
            throw new MoreThanOnePluginPerFolderException("Found " + pluginsFound.size() + " plugins");
        }
        if (pluginsFound.size() == 1) {
            ((PluginInfo)pluginsFound.get(0)).setPluginFolder(pluginsFolder);
        }
        return pluginsFound.isEmpty() ? null : (PluginInfo)pluginsFound.get(0);
    }

    private Set<PluginInfo> getPluginsInJar(URI jarURI) throws PluginSystemException {
        Manifest jarManifest = new JarUtils().getManifestFromJar(jarURI);
        if (jarManifest == null) {
            return new HashSet<PluginInfo>();
        }
        HashSet<PluginInfo> result = new HashSet<PluginInfo>();
        ManifestReader manifestReader = new ManifestReader();
        for (String entryName : jarManifest.getEntries().keySet()) {
            try {
                Attributes entry = jarManifest.getEntries().get(entryName);
                manifestReader.validateManifestEntry(jarURI, entryName, entry);
                result.add(this.getPluginInfoFromJarEntry(jarURI, entryName, entry, manifestReader));
            }
            catch (PluginSystemException e) {
                PluginSystemLogger.getLogger().severe("Error loading plugin: " + entryName);
                PluginSystemLogger.getLogger().severe("Error is: " + e.getMessage());
            }
        }
        return result;
    }

    private PluginInfo getPluginInfoFromJarEntry(URI jarURI, String entryName, Attributes entryAttributes, ManifestReader manifestReader) throws PluginSystemException {
        PluginInfo pluginInfo = new PluginInfo();
        pluginInfo.setName(entryName);
        pluginInfo.setClassName(manifestReader.getPluginClass(entryAttributes));
        pluginInfo.setAuthor(manifestReader.getPluginAuthor(entryAttributes));
        pluginInfo.setVersion(PluginVersion.getPluginVersion(manifestReader.getPluginVersion(entryAttributes)));
        pluginInfo.setPluginOS(manifestReader.getPluginOs(entryAttributes));
        pluginInfo.setUrl(manifestReader.getPluginUrl(entryAttributes));
        this.setPluginInfoIcon(pluginInfo, jarURI, entryAttributes, manifestReader);
        return pluginInfo;
    }

    private void setPluginInfoIcon(PluginInfo pluginInfo, URI jarURI, Attributes entryAttributes, ManifestReader manifestReader) throws PluginSystemException {
        String pluginIcon = manifestReader.getPluginIcon(entryAttributes);
        if (pluginIcon != null) {
            InputStream is = null;
            try {
                try {
                    is = new JarUtils().getFileFromJar(jarURI, pluginIcon);
                    if (is != null) {
                        pluginInfo.setIcon(ImageIO.read(is));
                    }
                }
                catch (IOException e) {
                    throw new PluginSystemException(e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new PluginSystemException(e);
                    }
                }
            }
        }
    }
}

