/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class StringUtilities {
    private static MessageDigest digest;
    private static Pattern MBID_PATTERN;
    private static final Pattern MD5_PATTERN;

    public static String md5(String s) {
        try {
            byte[] bytes = digest.digest(s.getBytes("UTF-8"));
            StringBuilder b = new StringBuilder(32);
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte & 0xFF);
                if (hex.length() == 1) {
                    b.append('0');
                }
                b.append(hex);
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static boolean isMbid(String artistOrMbid) {
        return artistOrMbid.length() == 36 && MBID_PATTERN.matcher(artistOrMbid).matches();
    }

    public static Map<String, String> map(String ... strings) {
        if (strings.length % 2 != 0) {
            throw new IllegalArgumentException("strings.length % 2 != 0");
        }
        HashMap<String, String> mp = new HashMap<String, String>();
        for (int i = 0; i < strings.length; i += 2) {
            mp.put(strings[i], strings[i + 1]);
        }
        return mp;
    }

    public static String cleanUp(String s) {
        return s.replaceAll("[*:/\\\\?|<>\"]", "-");
    }

    public static boolean isMD5(String s) {
        return s.length() == 32 && MD5_PATTERN.matcher(s).matches();
    }

    static {
        MBID_PATTERN = Pattern.compile("^[0-9a-f]{8}\\-[0-9a-f]{4}\\-[0-9a-f]{4}\\-[0-9a-f]{4}\\-[0-9a-f]{12}$", 2);
        MD5_PATTERN = Pattern.compile("[a-zA-Z0-9]{32}");
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

