/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.scrobble;

public class ResponseStatus {
    public static final int OK = 0;
    public static final int BANNED = 1;
    public static final int BADAUTH = 2;
    public static final int BADTIME = 3;
    public static final int BADSESSION = 4;
    public static final int FAILED = 5;
    private int status;
    private String message;

    public ResponseStatus(int status) {
        this(status, null);
    }

    public ResponseStatus(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean ok() {
        return this.status == 0;
    }

    static int codeForStatus(String status) {
        if ("OK".equals(status)) {
            return 0;
        }
        if (status.startsWith("FAILED")) {
            return 5;
        }
        if ("BADAUTH".equals(status)) {
            return 2;
        }
        if ("BADSESSION".equals(status)) {
            return 4;
        }
        if ("BANNED".equals(status)) {
            return 1;
        }
        if ("BADTIME".equals(status)) {
            return 3;
        }
        return -1;
    }
}

