/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.roarsoftware.lastfm.cache.Cache;

public class DatabaseCache
extends Cache {
    protected static final String TABLE_NAME = "LASTFM_CACHE";
    protected Connection conn;

    public DatabaseCache(Connection connection) throws SQLException {
        this.conn = connection;
        ResultSet tables = this.conn.getMetaData().getTables(null, null, TABLE_NAME, null);
        if (!tables.next()) {
            this.createTable();
        }
    }

    protected void createTable() throws SQLException {
        PreparedStatement stmt = this.conn.prepareStatement("CREATE TABLE LASTFM_CACHE (key varchar, expiration_date timestamp, response longvarchar);");
        stmt.execute();
        stmt.close();
    }

    @Override
    public boolean contains(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("SELECT key FROM LASTFM_CACHE WHERE key = ?;");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            boolean b = result.next();
            stmt.close();
            return b;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public InputStream load(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("SELECT response FROM LASTFM_CACHE WHERE key = ?;");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                String s = result.getString("response");
                stmt.close();
                return new ByteArrayInputStream(s.getBytes("UTF-8"));
            }
            stmt.close();
        }
        catch (SQLException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void remove(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM LASTFM_CACHE WHERE key = ?;");
            stmt.setString(1, cacheEntryName);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void store(String cacheEntryName, InputStream inputStream, long expirationDate) {
        try {
            int read;
            InputStreamReader reader = new InputStreamReader(inputStream);
            StringBuilder sb = new StringBuilder(inputStream.available());
            char[] buf = new char[2048];
            while ((read = reader.read(buf, 0, buf.length)) != -1) {
                sb.append(buf, 0, read);
            }
            PreparedStatement stmt = this.conn.prepareStatement("INSERT INTO LASTFM_CACHE (key, expiration_date, response) VALUES(?, ?, ?);");
            stmt.setString(1, cacheEntryName);
            stmt.setTimestamp(2, new Timestamp(expirationDate));
            stmt.setString(3, sb.toString());
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isExpired(String cacheEntryName) {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("SELECT expiration_date FROM LASTFM_CACHE WHERE key = ?;");
            stmt.setString(1, cacheEntryName);
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                Timestamp timestamp = result.getTimestamp("expiration_date");
                long expirationDate = timestamp.getTime();
                stmt.close();
                return expirationDate < System.currentTimeMillis();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void clear() {
        try {
            PreparedStatement stmt = this.conn.prepareStatement("DELETE FROM LASTFM_CACHE;");
            stmt.execute();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

