/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.xml.DomElement;

public class Tasteometer {
    private Tasteometer() {
    }

    public static ComparisonResult compare(InputType type1, String value1, InputType type2, String value2, String apiKey) {
        Result result = Caller.getInstance().call("tasteometer.compare", apiKey, "type1", type1.name().toLowerCase(), "type2", type2.name().toLowerCase(), "value1", value1, "value2", value2);
        if (!result.isSuccessful()) {
            return null;
        }
        DomElement element = result.getContentElement();
        DomElement re = element.getChild("result");
        float score = Float.parseFloat(re.getChildText("score"));
        ArrayList<Artist> artists = new ArrayList<Artist>();
        for (DomElement domElement : re.getChild("artists").getChildren("artist")) {
            artists.add(Artist.artistFromElement(domElement));
        }
        return new ComparisonResult(score, artists);
    }

    public static enum InputType {
        USER,
        ARTISTS,
        MYSPACE;

    }

    public static class ComparisonResult {
        private float score;
        private Collection<Artist> matches;

        ComparisonResult(float score, Collection<Artist> matches) {
            this.score = score;
            this.matches = matches;
        }

        public Collection<Artist> getMatches() {
            return this.matches;
        }

        public float getScore() {
            return this.score;
        }
    }
}

