/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.roarsoftware.lastfm.ImageHolder;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.xml.DomElement;

public class Image
extends ImageHolder {
    private static final DateFormat DATE_ADDED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
    private String title;
    private String url;
    private Date dateAdded;
    private String format;
    private String owner;
    private int thumbsUp;
    private int thumbsDown;

    private Image() {
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public String getFormat() {
        return this.format;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getThumbsUp() {
        return this.thumbsUp;
    }

    public int getThumbsDown() {
        return this.thumbsDown;
    }

    static Image imageFromElement(DomElement e) {
        DomElement votes;
        Image i = new Image();
        i.title = e.getChildText("title");
        i.url = e.getChildText("url");
        i.format = e.getChildText("format");
        try {
            i.dateAdded = DATE_ADDED_FORMAT.parse(e.getChildText("dateadded"));
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        DomElement owner = e.getChild("owner");
        if (owner != null) {
            i.owner = owner.getChildText("name");
        }
        if ((votes = e.getChild("votes")) != null) {
            i.thumbsUp = Integer.parseInt(votes.getChildText("thumbsup"));
            i.thumbsDown = Integer.parseInt(votes.getChildText("thumbsdown"));
        }
        DomElement sizes = e.getChild("sizes");
        for (DomElement image : sizes.getChildren("size")) {
            String attribute = image.getAttribute("name");
            ImageSize size = attribute == null ? ImageSize.MEDIUM : ImageSize.valueOf(attribute.toUpperCase(Locale.ENGLISH));
            i.imageUrls.put(size, image.getText());
        }
        return i;
    }
}

