/*
 * Decompiled with CFR 0.152.
 */
package net.roarsoftware.lastfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Caller;
import net.roarsoftware.lastfm.MusicEntry;
import net.roarsoftware.lastfm.Result;
import net.roarsoftware.lastfm.Track;
import net.roarsoftware.xml.DomElement;

public class Chart<T extends MusicEntry> {
    private Date from;
    private Date to;
    private Collection<T> entries;

    public Chart(Date from, Date to, Collection<T> entries) {
        this.from = from;
        this.to = to;
        this.entries = entries;
    }

    public Collection<T> getEntries() {
        return this.entries;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    static <T extends MusicEntry> Chart<T> getChart(String method, String sourceType, String source, String target, String from, String to, int limit, String apiKey) {
        Result result;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(sourceType, source);
        if (from != null && to != null) {
            params.put("from", from);
            params.put("to", to);
        }
        if (limit != -1) {
            params.put("limit", String.valueOf(limit));
        }
        if (!(result = Caller.getInstance().call(method, apiKey, params)).isSuccessful()) {
            return null;
        }
        DomElement element = result.getContentElement();
        Collection<DomElement> children = element.getChildren(target);
        ArrayList<MusicEntry> collection = new ArrayList<MusicEntry>(children.size());
        boolean targetArtist = "artist".equals(target);
        boolean targetTrack = "track".equals(target);
        boolean targetAlbum = "album".equals(target);
        for (DomElement domElement : children) {
            if (targetArtist) {
                collection.add(Artist.artistFromElement(domElement));
            }
            if (targetTrack) {
                collection.add(Track.trackFromElement(domElement));
            }
            if (!targetAlbum) continue;
            collection.add(Album.albumFromElement(domElement));
        }
        long fromTime = 1000L * Long.parseLong(element.getAttribute("from"));
        long toTime = 1000L * Long.parseLong(element.getAttribute("to"));
        return new Chart(new Date(fromTime), new Date(toTime), collection);
    }

    static LinkedHashMap<String, String> getWeeklyChartList(String sourceType, String source, String apiKey) {
        Result result = Caller.getInstance().call(sourceType + ".getWeeklyChartList", apiKey, sourceType, source);
        if (!result.isSuccessful()) {
            return new LinkedHashMap<String, String>(0);
        }
        DomElement element = result.getContentElement();
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        for (DomElement domElement : element.getChildren("chart")) {
            list.put(domElement.getAttribute("from"), domElement.getAttribute("to"));
        }
        return list;
    }

    static Collection<Chart> getWeeklyChartListAsCharts(String sourceType, String source, String apiKey) {
        Result result = Caller.getInstance().call(sourceType + ".getWeeklyChartList", apiKey, sourceType, source);
        if (!result.isSuccessful()) {
            return Collections.emptyList();
        }
        DomElement element = result.getContentElement();
        ArrayList<Chart> list = new ArrayList<Chart>();
        for (DomElement domElement : element.getChildren("chart")) {
            long fromTime = 1000L * Long.parseLong(domElement.getAttribute("from"));
            long toTime = 1000L * Long.parseLong(domElement.getAttribute("to"));
            list.add(new Chart(new Date(fromTime), new Date(toTime), null));
        }
        return list;
    }
}

