/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;
import org.commonjukebox.plugins.model.PluginApi;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

@PluginApi
public final class ImageUtils {
    public static final String FILES_EXTENSION = "png";

    private ImageUtils() {
    }

    public static ImageIcon resize(ImageIcon imageIcon, int n, int n2) {
        if (n == -1 || n2 == -1) {
            return imageIcon;
        }
        if (n == imageIcon.getIconWidth() && n2 == imageIcon.getIconHeight()) {
            return imageIcon;
        }
        int n3 = imageIcon.getIconWidth() > imageIcon.getIconHeight() ? imageIcon.getIconWidth() : imageIcon.getIconHeight();
        int n4 = (int)((float)imageIcon.getIconWidth() / (float)n3 * (float)n);
        int n5 = (int)((float)imageIcon.getIconHeight() / (float)n3 * (float)n2);
        return ImageUtils.scaleImageBicubic(imageIcon.getImage(), n4, n5);
    }

    public static ImageIcon scaleImageBicubic(Image image, int n, int n2) {
        if (image == null) {
            return null;
        }
        double d = (double)n / (double)n2;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        double d2 = (double)n3 / (double)n4;
        int n5 = n;
        int n6 = n2;
        if (d < d2) {
            n6 = (int)((double)n / d2);
        } else {
            n5 = (int)((double)n2 * d2);
        }
        if (n3 <= n5 && n4 <= n6) {
            BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(image, 0, 0, n5, n6, null);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }
        BufferedImage bufferedImage = GraphicsUtilities.createThumbnail((BufferedImage)ImageUtils.toBufferedImage(image), (int)n5, (int)n6);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon scaleImageBilinear(Image image, int n, int n2) {
        if (image == null) {
            return null;
        }
        double d = (double)n / (double)n2;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        double d2 = (double)n3 / (double)n4;
        int n5 = n;
        int n6 = n2;
        if (d < d2) {
            n6 = (int)((double)n / d2);
        } else {
            n5 = (int)((double)n2 * d2);
        }
        BufferedImage bufferedImage = new BufferedImage(n5, n6, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n5, n6, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static BufferedImage toBufferedImage(Image image) {
        BufferedImage bufferedImage;
        try {
            Image image2 = new ImageIcon(image).getImage();
            bufferedImage = new BufferedImage(image2.getWidth(null), image2.getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(image2, 0, 0, null);
            graphics2D.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger logger = new Logger();
            logger.info("IMAGE       ", "Maybe picture file with wrong ending?");
            logger.error("IMAGE       ", illegalArgumentException);
            return null;
        }
        return bufferedImage;
    }

    public static void writeImageToFile(Image image, String string) throws IOException {
        if (image == null) {
            return;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        String string2 = string;
        if (!string.toUpperCase().endsWith(StringUtils.getString(".", FILES_EXTENSION).toUpperCase())) {
            string2 = StringUtils.getString(string, ".", FILES_EXTENSION);
        }
        ImageIO.write((RenderedImage)bufferedImage, FILES_EXTENSION, new FileOutputStream(string2));
    }
}

