/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.youtube;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.kernel.modules.webservices.youtube.YoutubeResultEntry;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.NetworkUtils;
import net.sourceforge.atunes.utils.StringUtils;
import net.sourceforge.atunes.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class YoutubeService {
    private static final String QUERY_STRING_WILDCARD = "%QUERY%";
    private static final String START_INDEX_WILDCARD = "%STARTINDEX%";
    public static final int MAX_RESULTS = 10;
    private static final String SEARCH_URL = StringUtils.getString("http://gdata.youtube.com/feeds/api/videos?vq=", "%QUERY%", "&max-results=", Integer.toString(10), "&start-index=", "%STARTINDEX%");
    private Logger logger;
    private Proxy proxy;
    private static YoutubeService instance;

    private YoutubeService(ProxyBean proxyBean) {
        Proxy proxy = null;
        try {
            if (proxyBean != null) {
                proxy = Proxy.getProxy(proxyBean);
            }
        }
        catch (Exception exception) {
            this.getLogger().error("SERVICE     ", exception);
        }
        this.proxy = proxy;
    }

    public static YoutubeService getInstance() {
        if (instance == null) {
            instance = new YoutubeService(ApplicationState.getInstance().getProxy());
        }
        return instance;
    }

    public void updateService() {
        instance = null;
    }

    public List<YoutubeResultEntry> searchInYoutube(String string, int n) {
        try {
            String string2 = NetworkUtils.encodeString(string);
            string2 = string2.replaceAll("\\+", "%20");
            String string3 = SEARCH_URL.replaceAll(QUERY_STRING_WILDCARD, string2).replaceAll(START_INDEX_WILDCARD, Integer.toString(n));
            Document document = XMLUtils.getXMLDocument(NetworkUtils.readURL(NetworkUtils.getConnection(string3, this.proxy)));
            if (document == null) {
                return Collections.emptyList();
            }
            return this.analyzeResultXml(n, document);
        }
        catch (Exception exception) {
            this.getLogger().error("SERVICE     ", exception);
            return Collections.emptyList();
        }
    }

    private List<YoutubeResultEntry> analyzeResultXml(int n, Document document) throws IOException {
        ArrayList<YoutubeResultEntry> arrayList = new ArrayList<YoutubeResultEntry>();
        NodeList nodeList = document.getElementsByTagName("entry");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            int n2;
            Node node;
            Object object;
            Object object2;
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element)) continue;
            YoutubeResultEntry youtubeResultEntry = new YoutubeResultEntry();
            Element element = (Element)node2;
            Element element2 = (Element)element.getElementsByTagName("media:group").item(0);
            String string2 = element2.getElementsByTagName("media:title").item(0).getTextContent();
            youtubeResultEntry.setName(string2);
            NodeList nodeList2 = element2.getElementsByTagName("media:player");
            if (nodeList2 != null && (object2 = nodeList2.item(0)) != null) {
                object = ((Element)object2).getAttribute("url");
                youtubeResultEntry.setUrl((String)object);
            }
            if ((object2 = element2.getElementsByTagName("media:thumbnail")) != null && (node = object2.item(n2 = object2.getLength() / 2)) != null) {
                string = ((Element)node).getAttribute("url");
                Image image = NetworkUtils.getImage(NetworkUtils.getConnection(string, this.proxy));
                youtubeResultEntry.setImage(ImageUtils.scaleImageBicubic(image, 75, 75));
            }
            if ((object = element2.getElementsByTagName("yt:duration")) != null && (node = object.item(0)) != null && (string = ((Element)node).getAttribute("seconds")) != null) {
                youtubeResultEntry.setDuration(StringUtils.seconds2String(Long.parseLong(string)));
            }
            if (youtubeResultEntry.getUrl() == null) continue;
            arrayList.add(youtubeResultEntry);
        }
        return arrayList;
    }

    public String getDirectUrlToBeAbleToPlaySong(String string) {
        try {
            String string2 = NetworkUtils.readURL(NetworkUtils.getConnection(string, this.proxy));
            int n = string2.indexOf("swfArgs");
            string2 = string2.substring(n + 1, string2.length());
            n = string2.indexOf("\"video_id\":");
            String string3 = string2.substring(n, string2.length());
            int n2 = string3.indexOf(58);
            int n3 = string3.indexOf("\",");
            String string4 = string3.substring(n2 + 3, n3);
            n = string2.indexOf("\"t\":");
            string3 = string2.substring(n, string2.length());
            n2 = string3.indexOf(58);
            n3 = string3.indexOf("\",");
            String string5 = string3.substring(n2 + 3, n3);
            String string6 = "18";
            String string7 = StringUtils.getString("http://youtube.com/get_video?video_id=", string4, "&t=", string5, "&fmt=", string6);
            return string7;
        }
        catch (Exception exception) {
            this.getLogger().error("SERVICE     ", exception);
            return null;
        }
    }

    public String getSearchForAudioObject(AudioObject audioObject) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (!Artist.isUnknownArtist(audioObject.getArtist())) {
            stringBuilder.append(audioObject.getArtist());
        }
        if ((string = audioObject.getTitle()) != null && !string.trim().equals("")) {
            string = string.replaceAll("\\(.*\\)", "");
            string = string.replaceAll("\\{.*\\}", "");
            if ((string = string.replaceAll("\\[.*\\]", "")).trim().isEmpty()) {
                string = audioObject.getTitle();
            }
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

