/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.Lyrics;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.engines.AbstractLyricsEngine;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WinampcnEngine
extends AbstractLyricsEngine {
    private static final String QUERY_URL = "http://www.winampcn.com/lyrictransfer/get.aspx?song=%1&artist=%2&lsong=%3";
    private static final String LYRC_URL = "http://www.winampcn.com/lyrictransfer/lrc.aspx?id=%1&ti=%2";

    public WinampcnEngine(Proxy proxy) {
        super(proxy);
    }

    @Override
    public Lyrics getLyricsFor(String string, String string2) {
        String string3 = this.getUrl(string, string2);
        try {
            String string4 = WinampcnEngine.readURL(this.getConnection(string3), "gbk");
            String string5 = this.getMostPopularLyrcUrl(string4);
            if (string5 == null) {
                return null;
            }
            String string6 = WinampcnEngine.readURL(this.getConnection(string5), "gbk");
            return (string6 = string6.replaceAll("\\[.+\\]", "")) == null || string6.isEmpty() ? null : new Lyrics(string6, string5);
        }
        catch (IOException iOException) {
            new Logger().error("SERVICE     ", StringUtils.getString(iOException.getClass().getCanonicalName(), " (", iOException.getMessage(), ")"));
            return null;
        }
    }

    private String getMostPopularLyrcUrl(String string) {
        List<LyrcCandidate> list = new LyrcXMLParser().parse(string);
        LyrcCandidate lyrcCandidate = null;
        for (LyrcCandidate lyrcCandidate2 : list) {
            if (lyrcCandidate == null) {
                lyrcCandidate = lyrcCandidate2;
                continue;
            }
            lyrcCandidate = lyrcCandidate2.downloadCount > lyrcCandidate.downloadCount ? lyrcCandidate2 : lyrcCandidate;
        }
        if (lyrcCandidate != null) {
            return LYRC_URL.replace("%1", String.valueOf(lyrcCandidate.id)).replace("%2", this.encodeUrl(lyrcCandidate.songName));
        }
        return null;
    }

    private String getUrl(String string, String string2) {
        return QUERY_URL.replace("%1", this.encodeUrl(string2)).replace("%2", this.encodeUrl(string)).replace("%3", this.encodeUrl(string2));
    }

    private CharSequence encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    @Override
    public String getLyricsProviderName() {
        return "winampcn.com";
    }

    @Override
    public String getUrlForAddingNewLyrics(String string, String string2) {
        return "";
    }

    private static class LyrcXMLParser
    extends DefaultHandler {
        List<LyrcCandidate> lyrcs = new ArrayList<LyrcCandidate>();

        private LyrcXMLParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("LyricUrl")) {
                LyrcCandidate lyrcCandidate = new LyrcCandidate();
                lyrcCandidate.id = Integer.parseInt(attributes.getValue("id"));
                lyrcCandidate.songName = attributes.getValue("SongName");
                lyrcCandidate.downloadCount = Integer.parseInt(attributes.getValue("downloadtimes"));
                this.lyrcs.add(lyrcCandidate);
            }
        }

        public List<LyrcCandidate> parse(String string) {
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse((InputStream)new ByteArrayInputStream(string.getBytes("gbk")), (DefaultHandler)this);
            }
            catch (Exception exception) {
                new Logger().error("SERVICE     ", "Cannot parse lyrics list from winampcn: " + exception.getMessage());
            }
            return this.lyrcs;
        }
    }

    private static class LyrcCandidate {
        int id;
        int downloadCount;
        String songName;

        private LyrcCandidate() {
        }
    }
}

