/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.webservices.lastfm;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.AlbumListInfo;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.kernel.modules.context.SimilarArtistsInfo;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.SubmissionData;
import net.sourceforge.atunes.misc.AbstractCache;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.StringUtils;
import net.sourceforge.atunes.utils.XMLUtils;
import org.apache.commons.io.FileUtils;

public class LastFmCache
extends AbstractCache {
    private static final String ARTIST_WIKI = "artistWiki";
    private static final String ARTIST_THUMB = "artistThumb";
    private static final String ARTIST_SIMILAR = "artistSimilar";
    private static final String ALBUM_LIST = "albumList";
    private static final String ARTIST_IMAGE = "artistImage";
    private static final String ALBUM_INFO = "albumInfo";
    private static final String ALBUM_COVER = "albumCover";
    private Logger logger;
    private static File submissionCacheDir = new File(StringUtils.getString(SystemProperties.getUserConfigFolder(Kernel.isDebug()), SystemProperties.FILE_SEPARATOR, "cache", SystemProperties.FILE_SEPARATOR, "lastfm", SystemProperties.FILE_SEPARATOR, "submission"));

    public LastFmCache() {
        super(LastFmCache.class.getResource("/settings/ehcache-lastfm.xml"));
    }

    public synchronized boolean clearCache() {
        boolean bl = false;
        try {
            this.getAlbumCoverCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from album cover cache");
            bl = true;
        }
        try {
            this.getAlbumInfoCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from album info cache");
            bl = true;
        }
        try {
            this.getArtistImageCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from artist image cache");
            bl = true;
        }
        try {
            this.getAlbumListCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from album list cache");
            bl = true;
        }
        try {
            this.getSimilarArtistsCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from similar artist cache");
            bl = true;
        }
        try {
            this.getArtistThumbsCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from artist thumbs cache");
            bl = true;
        }
        try {
            this.getArtistWikiCache().removeAll();
        }
        catch (Exception exception) {
            this.getLogger().info("FILE DELETE ", "Could not delete all files from artist wiki cache");
            bl = true;
        }
        return bl;
    }

    private synchronized File getSubmissionDataDir() throws IOException {
        if (!submissionCacheDir.exists()) {
            FileUtils.forceMkdir((File)submissionCacheDir);
        }
        return submissionCacheDir;
    }

    private String getFileNameForSubmissionCache() throws IOException {
        File file = this.getSubmissionDataDir();
        if (file == null) {
            return null;
        }
        return StringUtils.getString(file.getAbsolutePath(), SystemProperties.FILE_SEPARATOR, "submissionDataCache.xml");
    }

    public synchronized Image retrieveAlbumCover(AlbumInfo albumInfo) {
        Element element = this.getAlbumCoverCache().get((Serializable)albumInfo);
        if (element == null) {
            return null;
        }
        return ((ImageIcon)element.getValue()).getImage();
    }

    public synchronized AlbumInfo retrieveAlbumInfo(String string, String string2) {
        Element element = this.getAlbumInfoCache().get((Serializable)((Object)(string + string2)));
        if (element == null) {
            return null;
        }
        return (AlbumInfo)element.getValue();
    }

    public synchronized Image retrieveArtistImage(String string) {
        Element element = this.getArtistImageCache().get((Serializable)((Object)string));
        if (element == null) {
            return null;
        }
        return ((ImageIcon)element.getValue()).getImage();
    }

    public synchronized AlbumListInfo retrieveAbumList(String string) {
        Element element = this.getAlbumListCache().get((Serializable)((Object)string));
        if (element == null) {
            return null;
        }
        return (AlbumListInfo)element.getValue();
    }

    public synchronized SimilarArtistsInfo retrieveArtistSimilar(String string) {
        Element element = this.getSimilarArtistsCache().get((Serializable)((Object)string));
        if (element == null) {
            return null;
        }
        return (SimilarArtistsInfo)element.getValue();
    }

    public synchronized Image retrieveArtistThumbImage(ArtistInfo artistInfo) {
        Element element = this.getArtistThumbsCache().get((Serializable)artistInfo);
        if (element == null) {
            return null;
        }
        return ((ImageIcon)element.getValue()).getImage();
    }

    public synchronized String retrieveArtistWiki(String string) {
        Element element = this.getArtistWikiCache().get((Serializable)((Object)string));
        if (element == null) {
            return null;
        }
        return (String)((Object)element.getValue());
    }

    public synchronized void storeAlbumCover(AlbumInfo albumInfo, ImageIcon imageIcon) {
        if (imageIcon == null || albumInfo == null) {
            return;
        }
        Element element = new Element((Serializable)albumInfo, (Serializable)imageIcon);
        this.getAlbumCoverCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored album Cover for album ", albumInfo.getTitle());
    }

    public synchronized void storeAlbumInfo(String string, String string2, AlbumInfo albumInfo) {
        if (string == null || string2 == null || albumInfo == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)(string + string2)), (Serializable)albumInfo);
        this.getAlbumInfoCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored album info for album ", string, " ", string2);
    }

    public synchronized void storeArtistImage(String string, ImageIcon imageIcon) {
        if (imageIcon == null || string == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)string), (Serializable)imageIcon);
        this.getArtistImageCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored artist image for ", string);
    }

    public synchronized void storeAlbumList(String string, AlbumListInfo albumListInfo) {
        if (string == null || albumListInfo == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)string), (Serializable)albumListInfo);
        this.getAlbumListCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored album list for ", string);
    }

    public synchronized void storeArtistSimilar(String string, SimilarArtistsInfo similarArtistsInfo) {
        if (string == null || similarArtistsInfo == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)string), (Serializable)similarArtistsInfo);
        this.getSimilarArtistsCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored artist similar for ", string);
    }

    public synchronized void storeArtistThumbImage(ArtistInfo artistInfo, ImageIcon imageIcon) {
        if (imageIcon == null || artistInfo == null) {
            return;
        }
        Element element = new Element((Serializable)artistInfo, (Serializable)imageIcon);
        this.getArtistThumbsCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored artist thumb for ", artistInfo.getName());
    }

    public synchronized void storeArtistWiki(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        Element element = new Element((Serializable)((Object)string), (Serializable)((Object)string2));
        this.getArtistWikiCache().put(element);
        this.getLogger().debug("CACHE       ", "Stored artist wiki for ", string);
    }

    public synchronized void addSubmissionData(SubmissionData submissionData) {
        List<SubmissionData> list = this.getSubmissionData();
        list.add(submissionData);
        Collections.sort(list, new SubmissionDataComparator());
        try {
            String string = this.getFileNameForSubmissionCache();
            if (string != null) {
                XMLUtils.writeObjectToFile(list, string);
                this.getLogger().debug("CACHE       ", "Stored submission data: ", submissionData);
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("CACHE       ", iOException);
        }
    }

    public synchronized List<SubmissionData> getSubmissionData() {
        try {
            String string = this.getFileNameForSubmissionCache();
            if (string != null && new File(string).exists()) {
                return (List)XMLUtils.readObjectFromFile(string);
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("CACHE       ", iOException);
        }
        return new ArrayList<SubmissionData>();
    }

    public synchronized void removeSubmissionData() {
        try {
            String string = this.getFileNameForSubmissionCache();
            if (string != null && new File(string).exists()) {
                XMLUtils.writeObjectToFile(new ArrayList(), string);
            }
        }
        catch (IOException iOException) {
            this.getLogger().error("CACHE       ", iOException);
        }
    }

    private Cache getArtistWikiCache() {
        return this.getCache(ARTIST_WIKI);
    }

    private Cache getArtistThumbsCache() {
        return this.getCache(ARTIST_THUMB);
    }

    private Cache getSimilarArtistsCache() {
        return this.getCache(ARTIST_SIMILAR);
    }

    private Cache getAlbumListCache() {
        return this.getCache(ALBUM_LIST);
    }

    private Cache getArtistImageCache() {
        return this.getCache(ARTIST_IMAGE);
    }

    private Cache getAlbumInfoCache() {
        return this.getCache(ALBUM_INFO);
    }

    private Cache getAlbumCoverCache() {
        return this.getCache(ALBUM_COVER);
    }

    public void shutdown() {
        this.getAlbumCoverCache().dispose();
        this.getAlbumInfoCache().dispose();
        this.getAlbumListCache().dispose();
        this.getArtistImageCache().dispose();
        this.getSimilarArtistsCache().dispose();
        this.getArtistThumbsCache().dispose();
        this.getArtistWikiCache().dispose();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private static class SubmissionDataComparator
    implements Comparator<SubmissionData> {
        private SubmissionDataComparator() {
        }

        @Override
        public int compare(SubmissionData submissionData, SubmissionData submissionData2) {
            return Integer.valueOf(submissionData.getStartTime()).compareTo(submissionData2.getStartTime());
        }
    }
}

