/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.state;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.columns.ColumnSets;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.player.Volume;
import net.sourceforge.atunes.kernel.modules.playlist.ListOfPlayLists;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.exception.InconsistentRepositoryException;
import net.sourceforge.atunes.kernel.modules.repository.favorites.Favorites;
import net.sourceforge.atunes.kernel.modules.repository.statistics.Statistics;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateChangeListener;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.kernel.modules.tray.SystemTrayHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.Timer;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.CryptoUtils;
import net.sourceforge.atunes.utils.StringUtils;
import net.sourceforge.atunes.utils.XMLUtils;

public final class ApplicationStateHandler
extends AbstractHandler {
    private static ApplicationStateHandler instance = new ApplicationStateHandler();
    private Set<ApplicationStateChangeListener> stateChangeListeners;

    @Override
    protected void initHandler() {
    }

    public static ApplicationStateHandler getInstance() {
        return instance;
    }

    @Override
    public void applicationStarted() {
    }

    public void addStateChangeListener(ApplicationStateChangeListener applicationStateChangeListener) {
        if (this.stateChangeListeners == null) {
            this.stateChangeListeners = new HashSet<ApplicationStateChangeListener>();
        }
        this.stateChangeListeners.add(applicationStateChangeListener);
    }

    public void removeStateChangeListener(ApplicationStateChangeListener applicationStateChangeListener) {
        if (this.stateChangeListeners == null) {
            return;
        }
        this.stateChangeListeners.remove(applicationStateChangeListener);
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
    }

    public void notifyApplicationStateChanged() {
        try {
            for (ApplicationStateChangeListener applicationStateChangeListener : this.stateChangeListeners) {
                ApplicationStateHandler.getLogger().debug("HANDLER     ", "Call to ApplicationStateChangeListener: ", applicationStateChangeListener.getClass().getName());
                applicationStateChangeListener.applicationStateChanged(ApplicationState.getInstance());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void applicationFinish() {
        this.storeState();
    }

    public void applyState() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        if (ApplicationState.getInstance().isShowTrayPlayer()) {
            SystemTrayHandler.getInstance().initTrayPlayerIcons();
        }
        if (ApplicationState.getInstance().isShowSystemTray()) {
            SystemTrayHandler.getInstance().initTrayIcon();
        } else {
            GuiHandler.getInstance().setFrameDefaultCloseOperation(2);
        }
        if (ApplicationState.getInstance().isEnableHotkeys()) {
            HotkeyHandler.getInstance().enableHotkeys(ApplicationState.getInstance().getHotkeysConfig());
        } else {
            HotkeyHandler.getInstance().disableHotkeys();
        }
        GuiHandler.getInstance().showToolBar(ApplicationState.getInstance().isShowToolBar());
        GuiHandler.getInstance().showStatusBar(ApplicationState.getInstance().isShowStatusBar());
        GuiHandler.getInstance().showSongProperties(ApplicationState.getInstance().isShowAudioObjectProperties());
        GuiHandler.getInstance().showContextPanel(ApplicationState.getInstance().isUseContext());
        GuiHandler.getInstance().showNavigationTree(ApplicationState.getInstance().isShowNavigationTree());
        GuiHandler.getInstance().showNavigationTable(ApplicationState.getInstance().isShowNavigationTable());
        ControllerProxy.getInstance().getNavigationController().setNavigationView(ApplicationState.getInstance().getNavigationView());
        Volume.setVolume(ApplicationState.getInstance().getVolume());
        PlayerHandler.getInstance().applyMuteState(ApplicationState.getInstance().isMuteEnabled());
        ((PlayerControlsPanel)ControllerProxy.getInstance().getPlayerControlsController().getComponentControlled()).setShowTicksAndLabels(ApplicationState.getInstance().isShowTicks());
    }

    private String getPropertiesFile(boolean bl) {
        return StringUtils.getString(SystemProperties.getUserConfigFolder(bl), "/", "aTunesConfig.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFavoritesCache(Favorites favorites) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(StringUtils.getString(this.getUserConfigFolder(), "/", "favorites.dat")));
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Storing favorites information...");
            objectOutputStream.writeObject(favorites);
            ClosingUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write favorites");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
        finally {
            ClosingUtils.close(objectOutputStream);
        }
        if (ApplicationState.getInstance().isSaveRepositoryAsXml()) {
            try {
                XMLUtils.writeObjectToFile(favorites, StringUtils.getString(this.getUserConfigFolder(), "/", "favorites.xml"));
                ApplicationStateHandler.getLogger().info("HANDLER     ", "Storing favorites information...");
            }
            catch (Exception exception) {
                ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write favorites");
                ApplicationStateHandler.getLogger().debug("HANDLER     ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistStatisticsCache(Statistics statistics) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(StringUtils.getString(this.getUserConfigFolder(), "/", "statistics.dat")));
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Storing statistics information...");
            objectOutputStream.writeObject(statistics);
            ClosingUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write statistics");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
        finally {
            ClosingUtils.close(objectOutputStream);
        }
        if (ApplicationState.getInstance().isSaveRepositoryAsXml()) {
            try {
                XMLUtils.writeObjectToFile(statistics, StringUtils.getString(this.getUserConfigFolder(), "/", "statistics.xml"));
                ApplicationStateHandler.getLogger().info("HANDLER     ", "Storing statistics information...");
            }
            catch (Exception exception) {
                ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write statistics");
                ApplicationStateHandler.getLogger().debug("HANDLER     ", exception);
            }
        }
    }

    public void persistPlayListsDefinition(ListOfPlayLists listOfPlayLists) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            XMLUtils.writeObjectToFile(listOfPlayLists, StringUtils.getString(this.getUserConfigFolder(), "/", "playLists.xml"));
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Playlists definition saved");
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not persist playlists definition");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistPlayListsContents(List<List<AudioObject>> list) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(StringUtils.getString(this.getUserConfigFolder(), "/", "playListsContents.dat")));
            objectOutputStream.writeObject(list);
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Playlists contents saved");
            ClosingUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not persist playlists contents");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
        finally {
            ClosingUtils.close(objectOutputStream);
        }
    }

    public void persistPodcastFeedCache(List<PodcastFeed> list) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            XMLUtils.writeObjectToFile(list, StringUtils.getString(this.getUserConfigFolder(), "/", "podcastFeeds.xml"));
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not persist podcast feeds");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
    }

    public void persistRadioCache(List<Radio> list) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            XMLUtils.writeObjectToFile(list, StringUtils.getString(this.getUserConfigFolder(), "/", "radios.xml"));
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not persist radios");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
    }

    public void persistPresetRadioCache(List<Radio> list) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            XMLUtils.writeObjectToFile(list, StringUtils.getString(this.getUserConfigFolder(), "/", "preset_radios.xml"));
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not persist radios");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistRepositoryCache(Repository repository, boolean bl) {
        Object object;
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        String string = RepositoryHandler.getInstance().getRepositoryConfigurationFolder();
        ObjectOutputStream objectOutputStream = null;
        try {
            object = new FileOutputStream(StringUtils.getString(string, "/", "repository.dat"));
            objectOutputStream = new ObjectOutputStream((OutputStream)object);
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Serialize repository information...");
            Timer timer = new Timer();
            timer.start();
            objectOutputStream.writeObject(repository);
            ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("DONE (", timer.stop(), " seconds)"));
            ClosingUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write serialized repository");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
        finally {
            ClosingUtils.close(objectOutputStream);
        }
        if (bl && ApplicationState.getInstance().isSaveRepositoryAsXml()) {
            try {
                ApplicationStateHandler.getLogger().info("HANDLER     ", "Storing repository information as xml...");
                object = new Timer();
                ((Timer)object).start();
                XMLUtils.writeObjectToFile(repository, StringUtils.getString(string, "/", "repository.xml"));
                ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("DONE (", ((Timer)object).stop(), " seconds)"));
            }
            catch (IOException iOException) {
                ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write repository as xml");
                ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistDeviceCache(String string, Repository repository) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(StringUtils.getString(this.getUserConfigFolder(), SystemProperties.FILE_SEPARATOR, "device.dat", string));
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Serialize device information...");
            long l = System.currentTimeMillis();
            objectOutputStream.writeObject(repository);
            long l2 = System.currentTimeMillis();
            ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("DONE (", (double)(l2 - l) / 1000.0, " seconds)"));
            ClosingUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Could not write serialized device");
            ApplicationStateHandler.getLogger().debug("HANDLER     ", iOException);
        }
        finally {
            ClosingUtils.close(objectOutputStream);
        }
    }

    public ApplicationState readState() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            ApplicationState applicationState = (ApplicationState)XMLUtils.readBeanFromFile(this.getPropertiesFile(Kernel.isDebug()));
            if (applicationState.getProxy() != null && applicationState.getProxy().getEncryptedPassword() != null && applicationState.getProxy().getEncryptedPassword().length > 0) {
                applicationState.getProxy().setPassword(new String(CryptoUtils.decrypt(applicationState.getProxy().getEncryptedPassword())));
            }
            if (applicationState.getEncryptedLastFmPassword() != null && applicationState.getEncryptedLastFmPassword().length > 0) {
                applicationState.setLastFmPassword(new String(CryptoUtils.decrypt(applicationState.getEncryptedLastFmPassword())));
            }
            return applicationState;
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Could not read application state");
            return new ApplicationState();
        }
        catch (GeneralSecurityException generalSecurityException) {
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Could not decrypt passord");
            return new ApplicationState();
        }
        catch (Exception exception) {
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Could not read application state");
            return new ApplicationState();
        }
    }

    /*
     * Exception decompiling
     */
    public Favorites retrieveFavoritesCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Statistics retrieveStatisticsCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ListOfPlayLists retrievePlayListsCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<PodcastFeed> retrievePodcastFeedCache() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            return (List)XMLUtils.readObjectFromFile(StringUtils.getString(this.getUserConfigFolder(), "/", "podcastFeeds.xml"));
        }
        catch (IOException iOException) {
            return new CopyOnWriteArrayList<PodcastFeed>();
        }
    }

    public List<Radio> retrieveRadioCache() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            return (List)XMLUtils.readObjectFromFile(StringUtils.getString(this.getUserConfigFolder(), "/", "radios.xml"));
        }
        catch (IOException iOException) {
            return new ArrayList<Radio>();
        }
    }

    public List<Radio> retrieveRadioPreset() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        try {
            return (List)XMLUtils.readObjectFromFile(StringUtils.getString(this.getUserConfigFolder(), "/", "preset_radios.xml"));
        }
        catch (IOException iOException) {
            try {
                return (List)XMLUtils.readObjectFromFile(ApplicationStateHandler.class.getResourceAsStream("/settings/preset_radios.xml"));
            }
            catch (IOException iOException2) {
                return new ArrayList<Radio>();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Repository retrieveRepositoryCache() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Repository exceptionReadingRepository(String string) {
        ApplicationStateHandler.getLogger().info("HANDLER     ", "No serialized repository info found");
        if (ApplicationState.getInstance().isSaveRepositoryAsXml()) {
            try {
                ApplicationStateHandler.getLogger().info("HANDLER     ", "Reading xml repository cache");
                long l = System.currentTimeMillis();
                Repository repository = (Repository)XMLUtils.readObjectFromFile(StringUtils.getString(string, "/", "repository.xml"));
                repository.validateRepository();
                long l2 = System.currentTimeMillis();
                ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("Reading repository cache done (", (double)(l2 - l) / 1000.0, " seconds)"));
                repository.setDirty(true);
                return repository;
            }
            catch (IOException iOException) {
                ApplicationStateHandler.getLogger().info("HANDLER     ", "No xml repository info found");
                return null;
            }
            catch (InconsistentRepositoryException inconsistentRepositoryException) {
                ApplicationStateHandler.getLogger().info("HANDLER     ", "No xml repository info found");
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Repository retrieveDeviceCache(String string) {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(StringUtils.getString(this.getUserConfigFolder(), SystemProperties.FILE_SEPARATOR, "device.dat", string));
            objectInputStream = new ObjectInputStream(fileInputStream);
            ApplicationStateHandler.getLogger().info("HANDLER     ", "Reading serialized device cache");
            long l = System.currentTimeMillis();
            Repository repository = (Repository)objectInputStream.readObject();
            long l2 = System.currentTimeMillis();
            ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("Reading device cache done (", (double)(l2 - l) / 1000.0, " seconds)"));
            Repository repository2 = repository;
            ClosingUtils.close(objectInputStream);
            return repository2;
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("No serialized device info found for deviceId: ", string));
            Repository repository = null;
            return repository;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ApplicationStateHandler.getLogger().info("HANDLER     ", StringUtils.getString("No serialized device info found for deviceId: ", string));
            Repository repository = null;
            return repository;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ClosingUtils.close(objectInputStream);
        }
    }

    private void storeState() {
        ApplicationStateHandler.getLogger().debug("HANDLER     ");
        if (!GuiHandler.getInstance().isMultipleWindow()) {
            ApplicationState.getInstance().setWindowXPosition(GuiHandler.getInstance().getWindowLocation().x);
            ApplicationState.getInstance().setWindowYPosition(GuiHandler.getInstance().getWindowLocation().y);
            ApplicationState.getInstance().setMaximized(GuiHandler.getInstance().isMaximized());
            ApplicationState.getInstance().setWindowWidth(GuiHandler.getInstance().getWindowSize().width);
            ApplicationState.getInstance().setWindowHeight(GuiHandler.getInstance().getWindowSize().height);
        } else {
            ApplicationState.getInstance().setMultipleViewXPosition(GuiHandler.getInstance().getWindowLocation().x);
            ApplicationState.getInstance().setMultipleViewYPosition(GuiHandler.getInstance().getWindowLocation().y);
            ApplicationState.getInstance().setMultipleViewWidth(GuiHandler.getInstance().getWindowSize().width);
            ApplicationState.getInstance().setMultipleViewHeight(GuiHandler.getInstance().getWindowSize().height);
        }
        ApplicationState.getInstance().setEqualizerSettings(PlayerHandler.getInstance().getEqualizer().getEqualizerValues());
        ColumnSets.storeColumnSettings();
        try {
            ApplicationState.getInstance().setEncryptedLastFmPassword(null);
            if (ApplicationState.getInstance().getLastFmPassword() != null && !ApplicationState.getInstance().getLastFmPassword().isEmpty()) {
                ApplicationState.getInstance().setEncryptedLastFmPassword(CryptoUtils.encrypt(ApplicationState.getInstance().getLastFmPassword().getBytes()));
            }
            if (ApplicationState.getInstance().getProxy() != null && ApplicationState.getInstance().getProxy().getPassword() != null && !ApplicationState.getInstance().getProxy().getPassword().isEmpty()) {
                ApplicationState.getInstance().getProxy().setEncryptedPassword(CryptoUtils.encrypt(ApplicationState.getInstance().getProxy().getPassword().getBytes()));
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", generalSecurityException);
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", iOException);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(ApplicationState.class);
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals("lastFmPassword")) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
            BeanInfo beanInfo2 = Introspector.getBeanInfo(ProxyBean.class);
            for (PropertyDescriptor propertyDescriptor : beanInfo2.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals("password")) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
            XMLUtils.writeBeanToFile(ApplicationState.getInstance(), this.getPropertiesFile(Kernel.isDebug()));
        }
        catch (IOException iOException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Error storing application state");
            ApplicationStateHandler.getLogger().error("HANDLER     ", iOException);
        }
        catch (IntrospectionException introspectionException) {
            ApplicationStateHandler.getLogger().error("HANDLER     ", "Error storing application state");
            ApplicationStateHandler.getLogger().error("HANDLER     ", introspectionException);
        }
    }

    private String getUserConfigFolder() {
        return SystemProperties.getUserConfigFolder(Kernel.isDebug());
    }
}

