/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.tags.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.AbstractChangeTagProcess;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;

public class SetGenresProcess
extends AbstractChangeTagProcess {
    private Map<AudioFile, String> filesAndGenres;

    SetGenresProcess(List<AudioFile> list) {
        super(list);
    }

    @Override
    protected void retrieveInformationBeforeChangeTags() {
        super.retrieveInformationBeforeChangeTags();
        this.filesAndGenres = this.getGenresForFiles(this.getFilesToChange());
    }

    @Override
    protected void changeTag(AudioFile audioFile) throws IOException {
        String string = this.filesAndGenres.get(audioFile);
        if (!audioFile.getGenre().equals(string)) {
            TagModifier.setGenre(audioFile, string);
        }
    }

    private Map<AudioFile, String> getGenresForFiles(List<AudioFile> list) {
        HashMap<AudioFile, String> hashMap = new HashMap<AudioFile, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (AudioFile audioFile : list) {
            if (Artist.isUnknownArtist(audioFile.getArtist())) continue;
            String string = null;
            if (hashMap2.containsKey(audioFile.getArtist())) {
                string = (String)hashMap2.get(audioFile.getArtist());
            } else {
                string = LastFmService.getInstance().getArtistTopTag(audioFile.getArtist());
                hashMap2.put(audioFile.getArtist(), string);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (string == null) continue;
            hashMap.put(audioFile, string);
        }
        return hashMap;
    }
}

