/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository.statistics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.AudioFileStats;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsAlbum;
import net.sourceforge.atunes.misc.RankList;

public class Statistics
implements Serializable {
    private static final long serialVersionUID = -3603927907730394505L;
    private int totalPlays;
    private int differentAudioFilesPlayed;
    private RankList<String> audioFilesRanking = new RankList();
    private RankList<StatisticsAlbum> albumsRanking = new RankList();
    private RankList<String> artistsRanking = new RankList();
    private Map<String, AudioFileStats> audioFilesStats = new HashMap<String, AudioFileStats>();

    public RankList<StatisticsAlbum> getAlbumsRanking() {
        return this.albumsRanking;
    }

    public RankList<String> getArtistsRanking() {
        return this.artistsRanking;
    }

    public int getDifferentAudioFilesPlayed() {
        return this.differentAudioFilesPlayed;
    }

    public RankList<String> getAudioFilesRanking() {
        return this.audioFilesRanking;
    }

    public Map<String, AudioFileStats> getAudioFilesStats() {
        return this.audioFilesStats;
    }

    public AudioFileStats getStatsForAudioFile(AudioFile audioFile) {
        if (audioFile != null) {
            return this.audioFilesStats.get(audioFile.getUrl());
        }
        return null;
    }

    public int getTotalPlays() {
        return this.totalPlays;
    }

    public void setDifferentAudioFilesPlayed(int n) {
        this.differentAudioFilesPlayed = n;
    }

    public void setAudioFilesStats(Map<String, AudioFileStats> map) {
        this.audioFilesStats = map;
    }

    public void setTotalPlays(int n) {
        this.totalPlays = n;
    }
}

