/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.repository;

import java.io.File;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.data.Folder;
import net.sourceforge.atunes.kernel.modules.repository.data.Genre;
import net.sourceforge.atunes.kernel.modules.repository.data.Repository;
import net.sourceforge.atunes.kernel.modules.repository.data.Year;
import net.sourceforge.atunes.misc.log.Logger;

final class RepositoryFiller {
    private RepositoryFiller() {
    }

    static void addToRepository(Repository repository, AudioFile audioFile) {
        repository.getAudioFiles().put(audioFile.getUrl(), audioFile);
        repository.setTotalSizeInBytes(repository.getTotalSizeInBytes() + audioFile.getFile().length());
        repository.addDurationInSeconds(audioFile.getDuration());
    }

    static void addToArtistStructure(Repository repository, AudioFile audioFile) {
        try {
            Album album;
            String string = audioFile.getAlbumArtistOrArtist();
            String string2 = audioFile.getAlbum();
            Artist artist = repository.getArtistStructure().get(string);
            if (artist == null) {
                artist = new Artist(string);
                repository.getArtistStructure().put(string, artist);
            }
            if ((album = artist.getAlbum(string2)) == null) {
                album = new Album(string2);
                album.setArtist(artist);
                artist.addAlbum(album);
            }
            album.addAudioFile(audioFile);
        }
        catch (Exception exception) {
            new Logger().error("FILE READ   ", exception.getMessage());
        }
    }

    static void addToGenreStructure(Repository repository, AudioFile audioFile) {
        try {
            String string = audioFile.getGenre();
            Genre genre = repository.getGenreStructure().get(string);
            if (genre == null) {
                genre = new Genre(string);
                repository.getGenreStructure().put(string, genre);
            }
            genre.addAudioFile(audioFile);
        }
        catch (Exception exception) {
            new Logger().error("FILE READ   ", exception.getMessage());
        }
    }

    static void addToYearStructure(Repository repository, AudioFile audioFile) {
        try {
            String string = audioFile.getYear();
            Year year = repository.getYearStructure().get(string);
            if (year == null) {
                year = new Year(string);
                repository.getYearStructure().put(string, year);
            }
            year.addAudioFile(audioFile);
        }
        catch (Exception exception) {
            new Logger().error("FILE READ   ", exception.getMessage());
        }
    }

    static void addToFolderStructure(Repository repository, File file, String string, AudioFile audioFile) {
        Folder folder = repository.getFolderStructure().get(file.getAbsolutePath());
        if (folder == null) {
            folder = new Folder(file.getAbsolutePath());
            repository.getFolderStructure().put(folder.getName(), folder);
        }
        String[] stringArray = string.split("/");
        Folder folder2 = folder;
        Folder folder3 = null;
        for (String string2 : stringArray) {
            if (folder2 != null) {
                folder3 = folder2.getFolder(string2);
                if (folder3 == null) {
                    folder3 = new Folder(string2);
                    folder2.addFolder(folder3);
                }
            } else {
                folder3 = repository.getFolderStructure().get(string2);
                if (folder3 == null) {
                    folder3 = new Folder(string2);
                    repository.getFolderStructure().put(folder3.getName(), folder3);
                }
            }
            folder2 = folder3;
        }
        if (folder2 == null) {
            folder2 = new Folder(".");
        }
        folder2.addAudioFile(audioFile);
    }
}

