/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.TransferProgressDialog;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.Kernel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntryDownloadChecker;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntryDownloader;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntryRetriever;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.FileNameUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class PodcastFeedHandler
extends AbstractHandler {
    private static PodcastFeedHandler instance = new PodcastFeedHandler();
    public static final long DEFAULT_PODCAST_FEED_ENTRIES_RETRIEVAL_INTERVAL = 180000L;
    private List<PodcastFeed> podcastFeeds;
    private boolean podcastFeedsDirty;
    private ExecutorService podcastFeedEntryDownloaderExecutorService = Executors.newCachedThreadPool();
    private volatile List<PodcastFeedEntryDownloader> runningDownloads = Collections.synchronizedList(new ArrayList());
    private ScheduledExecutorService podcastFeedEntryDownloadCheckerExecutorService = Executors.newScheduledThreadPool(1);
    private ScheduledExecutorService podcastFeedEntryRetrieverExecutorService = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledPodcastFeedEntryRetrieverFuture;

    @Override
    protected void initHandler() {
    }

    @Override
    public void applicationStarted() {
        this.startPodcastFeedEntryDownloadChecker();
        this.startPodcastFeedEntryRetriever();
    }

    public static PodcastFeedHandler getInstance() {
        return instance;
    }

    public void addPodcastFeed() {
        PodcastFeed podcastFeed = GuiHandler.getInstance().showAddPodcastFeedDialog();
        if (podcastFeed != null) {
            this.addPodcastFeed(podcastFeed);
            NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
            this.retrievePodcastFeedEntries();
        }
    }

    private void addPodcastFeed(PodcastFeed podcastFeed) {
        PodcastFeedHandler.getLogger().info("HANDLER     ", "Adding podcast feed");
        boolean bl = false;
        Comparator<PodcastFeed> comparator = PodcastFeed.getComparator();
        for (int i = 0; i < this.getPodcastFeeds().size(); ++i) {
            if (comparator.compare(podcastFeed, this.getPodcastFeeds().get(i)) >= 0) continue;
            this.getPodcastFeeds().add(i, podcastFeed);
            bl = true;
            break;
        }
        if (!bl) {
            this.getPodcastFeeds().add(podcastFeed);
        }
        this.podcastFeedsDirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applicationFinish() {
        this.podcastFeedEntryRetrieverExecutorService.shutdownNow();
        List<PodcastFeedEntryDownloader> list = this.runningDownloads;
        synchronized (list) {
            for (int i = 0; i < this.runningDownloads.size(); ++i) {
                PodcastFeedEntryDownloader podcastFeedEntryDownloader = this.runningDownloads.get(i);
                podcastFeedEntryDownloader.cancel(true);
                new File(this.getDownloadPath(podcastFeedEntryDownloader.getPodcastFeedEntry())).deleteOnExit();
            }
        }
        this.podcastFeedEntryDownloadCheckerExecutorService.shutdownNow();
        if (this.podcastFeedsDirty) {
            ApplicationStateHandler.getInstance().persistPodcastFeedCache(this.getPodcastFeeds());
        } else {
            PodcastFeedHandler.getLogger().info("PODCAST     ", "Podcast list is clean");
        }
    }

    @Override
    protected Runnable getPreviousInitializationTask() {
        return new Runnable(){

            @Override
            public void run() {
                PodcastFeedHandler.this.podcastFeeds = ApplicationStateHandler.getInstance().retrievePodcastFeedCache();
            }
        };
    }

    public List<PodcastFeed> getPodcastFeeds() {
        return this.podcastFeeds;
    }

    public List<PodcastFeedEntry> getPodcastFeedEntries() {
        ArrayList<PodcastFeedEntry> arrayList = new ArrayList<PodcastFeedEntry>();
        for (PodcastFeed podcastFeed : this.getPodcastFeeds()) {
            arrayList.addAll(podcastFeed.getPodcastFeedEntries());
        }
        return arrayList;
    }

    public void removePodcastFeed(PodcastFeed podcastFeed) {
        PodcastFeedHandler.getLogger().info("HANDLER     ", "Removing podcast feed");
        this.getPodcastFeeds().remove(podcastFeed);
        this.podcastFeedsDirty = true;
        NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
    }

    public void startPodcastFeedEntryRetriever() {
        long l = ApplicationState.getInstance().getPodcastFeedEntriesRetrievalInterval();
        long l2 = l > 0L ? l : 180000L;
        this.schedulePodcastFeedEntryRetriever(l2);
    }

    public void startPodcastFeedEntryDownloadChecker() {
        this.podcastFeedEntryDownloadCheckerExecutorService.scheduleWithFixedDelay(new PodcastFeedEntryDownloadChecker(), 0L, 10000L, TimeUnit.MILLISECONDS);
    }

    private void setPodcastFeedEntryRetrievalInterval(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("sleeping time must not be smaller than 0");
        }
        this.schedulePodcastFeedEntryRetriever(l);
    }

    private void schedulePodcastFeedEntryRetriever(long l) {
        if (this.scheduledPodcastFeedEntryRetrieverFuture != null) {
            this.scheduledPodcastFeedEntryRetrieverFuture.cancel(true);
        }
        this.scheduledPodcastFeedEntryRetrieverFuture = this.podcastFeedEntryRetrieverExecutorService.scheduleWithFixedDelay(new PodcastFeedEntryRetriever(this.getPodcastFeeds()), 0L, l, TimeUnit.MILLISECONDS);
    }

    public void retrievePodcastFeedEntries() {
        this.podcastFeedEntryRetrieverExecutorService.execute(new PodcastFeedEntryRetriever(this.getPodcastFeeds()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPodcastFeedEntry(final PodcastFeedEntry podcastFeedEntry) {
        if (this.isDownloading(podcastFeedEntry)) {
            return;
        }
        final TransferProgressDialog transferProgressDialog = GuiHandler.getInstance().getNewTransferProgressDialog(I18nUtils.getString("PODCAST_FEED_ENTRY_DOWNLOAD"), null);
        transferProgressDialog.setIcon(Images.getImage("rss.png"));
        final PodcastFeedEntryDownloader podcastFeedEntryDownloader = new PodcastFeedEntryDownloader(podcastFeedEntry);
        List<PodcastFeedEntryDownloader> list = this.runningDownloads;
        synchronized (list) {
            this.runningDownloads.add(podcastFeedEntryDownloader);
        }
        podcastFeedEntryDownloader.addPropertyChangeListener(new DownloadPodcastFeedEntryPropertyChangeListener(podcastFeedEntry, transferProgressDialog, podcastFeedEntryDownloader));
        transferProgressDialog.addCancelButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PodcastFeedHandler.this.cancelDownloading(podcastFeedEntry, transferProgressDialog, podcastFeedEntryDownloader);
            }
        });
        transferProgressDialog.setInfoText(podcastFeedEntry.getTitle());
        this.podcastFeedEntryDownloaderExecutorService.execute(podcastFeedEntryDownloader);
        transferProgressDialog.setVisible(true);
    }

    void cancelDownloading(final PodcastFeedEntry podcastFeedEntry, TransferProgressDialog transferProgressDialog, final PodcastFeedEntryDownloader podcastFeedEntryDownloader) {
        try {
            podcastFeedEntryDownloader.cancel(false);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        transferProgressDialog.dispose();
        final File file = new File(this.getDownloadPath(podcastFeedEntry));
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (file.exists() && !Thread.currentThread().isInterrupted()) {
                    file.delete();
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List list = PodcastFeedHandler.this.runningDownloads;
                synchronized (list) {
                    PodcastFeedHandler.this.runningDownloads.remove(podcastFeedEntryDownloader);
                }
                PodcastFeedHandler.getLogger().info("PODCAST     ", "podcast entry download cancelled: " + podcastFeedEntry.getTitle());
            }
        };
        new Thread(runnable).start();
    }

    public String getDownloadPath(PodcastFeedEntry podcastFeedEntry) {
        boolean bl;
        boolean bl2;
        File file;
        String string = ApplicationState.getInstance().getPodcastFeedEntryDownloadPath();
        if (string == null || string.isEmpty()) {
            string = StringUtils.getString(SystemProperties.getUserConfigFolder(Kernel.isDebug()), "/", "/podcasts");
        }
        if (!(file = new File(string)).exists() && !(bl2 = file.mkdir())) {
            PodcastFeedHandler.getLogger().error("PODCAST     ", "Problem Creating file!");
            return "";
        }
        if (podcastFeedEntry.getPodcastFeed().getName() == null || podcastFeedEntry.getPodcastFeed().getName().trim().isEmpty()) {
            return "";
        }
        File file2 = new File(file, FileNameUtils.getValidFileName(String.valueOf(podcastFeedEntry.getPodcastFeed().getName().hashCode())));
        if (!file2.exists() && !(bl = file2.mkdir())) {
            PodcastFeedHandler.getLogger().error("PODCAST     ", "Problem Creating file!");
            return "";
        }
        try {
            String string2 = new URI(podcastFeedEntry.getUrl()).getPath();
            String[] stringArray = string2.split("/");
            if (stringArray.length > 0) {
                String string3 = stringArray[stringArray.length - 1];
                int n = string3.lastIndexOf(46);
                string3 = n != -1 ? string3.hashCode() + "." + string3.substring(n, string3.length()) : String.valueOf(string3.hashCode());
                return file2.toString() + "/" + FileNameUtils.getValidFileName(string3);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            PodcastFeedHandler.getLogger().error("PODCAST     ", uRISyntaxException);
        }
        throw new IllegalArgumentException();
    }

    public boolean isDownloaded(PodcastFeedEntry podcastFeedEntry) {
        File file = new File(this.getDownloadPath(podcastFeedEntry));
        return file.exists();
    }

    public void deleteDownloadedPodcastFeedEntry(PodcastFeedEntry podcastFeedEntry) {
        File file = new File(this.getDownloadPath(podcastFeedEntry));
        new DeleteDownloadedPodcastFeedEntryWorker(file, podcastFeedEntry).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloading(PodcastFeedEntry podcastFeedEntry) {
        List<PodcastFeedEntryDownloader> list = this.runningDownloads;
        synchronized (list) {
            for (int i = 0; i < this.runningDownloads.size(); ++i) {
                if (!this.runningDownloads.get(i).getPodcastFeedEntry().equals(podcastFeedEntry)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void applicationStateChanged(ApplicationState applicationState) {
        this.setPodcastFeedEntryRetrievalInterval(applicationState.getPodcastFeedEntriesRetrievalInterval());
    }

    private static final class DeleteDownloadedPodcastFeedEntryWorker
    extends SwingWorker<Boolean, Void> {
        private final File f;
        private final PodcastFeedEntry podcastFeedEntry;

        private DeleteDownloadedPodcastFeedEntryWorker(File file, PodcastFeedEntry podcastFeedEntry) {
            this.f = file;
            this.podcastFeedEntry = podcastFeedEntry;
        }

        @Override
        protected Boolean doInBackground() {
            return this.f.delete();
        }

        @Override
        protected void done() {
            try {
                if (((Boolean)this.get()).booleanValue()) {
                    this.podcastFeedEntry.setDownloaded(false);
                    GuiHandler.getInstance().getNavigationTablePanel().getNavigationTable().repaint();
                }
            }
            catch (InterruptedException interruptedException) {
                PodcastFeedHandler.getLogger().error("PODCAST     ", interruptedException);
            }
            catch (ExecutionException executionException) {
                PodcastFeedHandler.getLogger().error("PODCAST     ", executionException);
            }
        }
    }

    private final class DownloadPodcastFeedEntryPropertyChangeListener
    implements PropertyChangeListener {
        private final PodcastFeedEntry podcastFeedEntry;
        private final TransferProgressDialog d;
        private final PodcastFeedEntryDownloader downloadPodcastFeedEntry;

        private DownloadPodcastFeedEntryPropertyChangeListener(PodcastFeedEntry podcastFeedEntry, TransferProgressDialog transferProgressDialog, PodcastFeedEntryDownloader podcastFeedEntryDownloader) {
            this.podcastFeedEntry = podcastFeedEntry;
            this.d = transferProgressDialog;
            this.downloadPodcastFeedEntry = podcastFeedEntryDownloader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("progress")) {
                this.d.setProgressBarValue((Integer)propertyChangeEvent.getNewValue());
                if ((Integer)propertyChangeEvent.getNewValue() == 100) {
                    this.d.dispose();
                    List list = PodcastFeedHandler.this.runningDownloads;
                    synchronized (list) {
                        PodcastFeedHandler.this.runningDownloads.remove(this.downloadPodcastFeedEntry);
                    }
                }
            } else if (propertyChangeEvent.getPropertyName().equals("byteProgress")) {
                this.d.setCurrentProgress((Long)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("totalBytes")) {
                this.d.setTotalProgress((Long)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("failed")) {
                PodcastFeedHandler.this.cancelDownloading(this.podcastFeedEntry, this.d, this.downloadPodcastFeedEntry);
            }
        }
    }
}

