/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.podcast;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.NetworkUtils;

public class PodcastFeedEntryDownloader
extends SwingWorker<Boolean, Void> {
    private Logger logger;
    private PodcastFeedEntry podcastFeedEntry;
    private volatile long totalBytes;
    private volatile long byteProgress;
    private volatile boolean failed;

    public PodcastFeedEntryDownloader(PodcastFeedEntry podcastFeedEntry) {
        this.podcastFeedEntry = podcastFeedEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected Boolean doInBackground() throws Exception {
        Boolean bl;
        this.getLogger().info("PODCAST     ", "Downloading PodcastEntry: " + this.podcastFeedEntry.getUrl());
        BufferedOutputStream bufferedOutputStream = null;
        InputStream inputStream = null;
        String string = PodcastFeedHandler.getInstance().getDownloadPath(this.podcastFeedEntry);
        this.getLogger().info("PODCAST     ", "Downloading to: " + string);
        File file = new File(string);
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            URLConnection uRLConnection = NetworkUtils.getConnection(this.podcastFeedEntry.getUrl(), Proxy.getProxy(ApplicationState.getInstance().getProxy()));
            inputStream = uRLConnection.getInputStream();
            this.setTotalBytes(uRLConnection.getContentLength());
            byte[] byArray = new byte[1024];
            long l = 0L;
            int n2 = 0;
            while ((n = inputStream.read(byArray)) != -1 && !this.isCancelled()) {
                n2 = n + n2;
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                l += (long)n;
                this.setByteProgress(n2);
                ((OutputStream)bufferedOutputStream).flush();
            }
            bl = !this.isCancelled();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getLogger().info("PODCAST     ", "file not found");
            this.setFailed(true);
            Boolean bl2 = false;
            ClosingUtils.close(bufferedOutputStream);
            ClosingUtils.close(inputStream);
            return bl2;
        }
        catch (IOException iOException) {
            this.getLogger().info("PODCAST     ", "Connection to " + this.podcastFeedEntry.getUrl() + " failed");
            this.setFailed(true);
            Boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    ClosingUtils.close(bufferedOutputStream);
                    ClosingUtils.close(inputStream);
                    throw throwable;
                }
            }
            ClosingUtils.close(bufferedOutputStream);
            ClosingUtils.close(inputStream);
            return bl3;
        }
        ClosingUtils.close(bufferedOutputStream);
        ClosingUtils.close(inputStream);
        return bl;
    }

    private void setTotalBytes(long l) {
        if (l == this.totalBytes) {
            return;
        }
        long l2 = this.byteProgress;
        this.totalBytes = l;
        if (this.getPropertyChangeSupport().hasListeners("totalBytes")) {
            this.firePropertyChange("totalBytes", l2, this.totalBytes);
        }
    }

    private void setByteProgress(long l) {
        if (l == this.byteProgress) {
            return;
        }
        long l2 = this.byteProgress;
        this.byteProgress = l;
        if (this.getPropertyChangeSupport().hasListeners("byteProgress")) {
            this.firePropertyChange("byteProgress", l2, this.byteProgress);
        }
        int n = (int)((double)l / (double)this.totalBytes * 100.0);
        this.setProgress(n);
    }

    private void setFailed(boolean bl) {
        if (bl == this.failed) {
            return;
        }
        boolean bl2 = this.failed;
        this.failed = bl;
        if (this.getPropertyChangeSupport().hasListeners("failed")) {
            this.firePropertyChange("failed", bl2, this.failed);
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    protected void done() {
        try {
            if (!this.isCancelled() && ((Boolean)this.get()).booleanValue()) {
                this.getLogger().info("PODCAST     ", "Download of " + this.podcastFeedEntry.getUrl() + " finished.");
                this.podcastFeedEntry.setDownloaded(true);
                GuiHandler.getInstance().getNavigationTablePanel().getNavigationTable().repaint();
            }
        }
        catch (InterruptedException interruptedException) {
            this.getLogger().error("PODCAST     ", interruptedException);
        }
        catch (ExecutionException executionException) {
            this.getLogger().error("PODCAST     ", executionException);
        }
    }

    public PodcastFeedEntry getPodcastFeedEntry() {
        return this.podcastFeedEntry;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

