/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.xine;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.AbstractPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.libxinejna.Xine;
import org.libxinejna.XineController;
import org.libxinejna.XineEventListener;

public class XineEngine
extends AbstractPlayerEngine {
    private XineController xineController;
    private Timer durationUpdater;
    private final Object xineLock = new Object();

    @Override
    protected boolean isEngineAvailable() {
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            return false;
        }
        try {
            String string = Xine.getLibXineVersion();
            this.info("Engine version: " + string);
            if (string != null && string.trim().length() > 0) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void pausePlayback() {
        if (this.xineController != null) {
            this.xineController.pause();
        }
    }

    @Override
    protected void resumePlayback() {
        if (this.xineController != null) {
            this.xineController.resume();
        }
    }

    @Override
    protected void startPlayback(AudioObject audioObject, AudioObject audioObject2) {
        boolean bl = true;
        if (this.xineController == null) {
            this.info("Creating xineController for playback");
            this.xineController = Xine.getXine().createController();
            this.xineController.registerXineEventListener((XineEventListener)new XineListener());
        } else {
            this.info("Stopping before new playback");
            this.internalStop();
        }
        this.info("Opening stream and setting xine params");
        this.xineController.open(audioObject.getUrl());
        this.xineController.setVolume(ApplicationState.getInstance().getVolume());
        this.applyEqualization(this.getEqualizer().getEqualizerValues());
        String string = null;
        int n = this.xineController.getStreamLength();
        if (audioObject instanceof PodcastFeedEntry || audioObject instanceof Radio) {
            if (!this.xineController.hasAudio()) {
                this.info("No audio found, go to next track");
                bl = false;
                string = StringUtils.getString(I18nUtils.getString("FILE_NOT_FOUND"), ": ", audioObject.getUrl());
            } else {
                long l = audioObject.getDuration() * 1000;
                this.setCurrentAudioObjectLength(l);
                this.notifyRadioOrPodcastFeedEntryStarted();
            }
        } else {
            if (n <= 0) {
                bl = false;
                string = StringUtils.getString(I18nUtils.getString("ERROR"), ": ", audioObject.getUrl());
            }
            this.setCurrentAudioObjectLength(n);
        }
        if (bl) {
            this.startPlayback(0L);
            this.info("Starting duration thread");
            this.durationUpdater = new Timer(250, new DurationUpdaterActionListener(audioObject));
            this.durationUpdater.start();
        } else {
            this.currentAudioObjectFinished(false, string);
        }
    }

    protected void setTime(int n) {
        super.setCurrentAudioObjectPlayedTime(n);
    }

    @Override
    protected void stopPlayback(boolean bl, boolean bl2) {
        if (this.xineController == null) {
            return;
        }
        this.stopDurationUpdater();
        if (bl2) {
            this.info("Fading away...");
            new FadeAwayThread("FadeAway").start();
        } else {
            this.info("Stopping without fade");
            this.internalStop();
        }
    }

    @Override
    protected void seekTo(long l) {
        if (this.xineController != null) {
            this.startPlayback(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishPlayer() {
        this.info("Finishing");
        try {
            if (this.xineController != null) {
                Object object = this.xineLock;
                synchronized (object) {
                    this.stopDurationUpdater();
                    this.xineController.dispose();
                    this.xineController = null;
                }
            }
            Xine.getXine().dispose();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.info("Error catched: " + unsatisfiedLinkError);
        }
        catch (Exception exception) {
            this.info("Error catched: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnginePlaying() {
        if (this.xineController != null) {
            Object object = this.xineLock;
            synchronized (object) {
                return this.xineController.isPlaying();
            }
        }
        return false;
    }

    @Override
    public void applyMuteState(boolean bl) {
        if (bl) {
            this.setVolume(0);
        } else {
            this.setVolume(ApplicationState.getInstance().getVolume());
        }
    }

    @Override
    public void setVolume(int n) {
        if (this.xineController != null) {
            this.xineController.setVolume(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStop() {
        this.info("Internal stop");
        if (this.xineController != null) {
            this.stopDurationUpdater();
            if (this.xineController.isPlaying() || this.xineController.isPaused()) {
                Object object = this.xineLock;
                synchronized (object) {
                    this.xineController.stop();
                }
            }
        }
    }

    private void startPlayback(long l) {
        this.info("Starting playback");
        try {
            this.xineController.start(0, (int)l);
        }
        catch (Exception exception) {
            this.info("Xine encountered an error: " + exception);
            this.currentAudioObjectFinished(false, "Xine encountered an error: ", exception.getMessage());
        }
    }

    private void stopDurationUpdater() {
        if (this.durationUpdater != null) {
            this.durationUpdater.stop();
            this.durationUpdater = null;
        }
    }

    protected void info(String string) {
        this.getLogger().info("PLAYER      ", "Xine: " + string);
    }

    protected void error(Exception exception) {
        this.getLogger().error("PLAYER      ", exception);
    }

    @Override
    public boolean supportsCapability(PlayerEngineCapability playerEngineCapability) {
        return EnumSet.of(PlayerEngineCapability.EQUALIZER, PlayerEngineCapability.EQUALIZER_CHANGE, PlayerEngineCapability.STREAMING).contains((Object)playerEngineCapability);
    }

    @Override
    public void applyEqualization(float[] fArray) {
        if (this.xineController != null && fArray != null) {
            fArray = this.transformEqualizerValues(fArray);
            int n = 0;
            int n2 = 18;
            while (n < fArray.length) {
                this.xineController.setParam(n2, (int)fArray[n]);
                ++n;
                ++n2;
            }
        }
    }

    @Override
    public float[] transformEqualizerValues(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        float f = 8.333333f;
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i] == 0.0f ? 0.0f : (float)((int)(f * fArray[i]));
        }
        return fArray2;
    }

    @Override
    protected String getEngineName() {
        return "Xine";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void killPlayer() {
        if (this.xineController != null) {
            Object object = this.xineLock;
            synchronized (object) {
                this.stopDurationUpdater();
                this.xineController.dispose();
                this.xineController = null;
            }
        }
        Xine.getXine().dispose();
    }

    @Override
    public void applyNormalization() {
    }

    protected class XineListener
    implements XineEventListener {
        protected XineListener() {
        }

        public void handleXineEvent(int n, byte[] byArray) {
            if (n == 1) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            XineEngine.this.currentAudioObjectFinished(true, new String[0]);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    XineEngine.this.error(interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    XineEngine.this.error(invocationTargetException);
                }
            }
        }
    }

    private final class DurationUpdaterActionListener
    implements ActionListener {
        private final AudioObject audioObjectToPlay;
        int prevPosition;

        private DurationUpdaterActionListener(AudioObject audioObject) {
            this.audioObjectToPlay = audioObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (XineEngine.this.isEnginePlaying()) {
                int n = -1;
                Object object = XineEngine.this.xineLock;
                synchronized (object) {
                    n = XineEngine.this.xineController.getStreamPos();
                }
                if (n >= 0) {
                    this.prevPosition = n;
                    XineEngine.this.setTime(this.prevPosition);
                    if (n < 1000) {
                        GuiHandler.getInstance().updateStatusBar(this.audioObjectToPlay);
                        GuiHandler.getInstance().updateTitleBar(this.audioObjectToPlay);
                    }
                }
            }
        }
    }

    private final class FadeAwayThread
    extends Thread {
        private FadeAwayThread(String string) {
            super(string);
        }

        @Override
        public void run() {
            int n = ApplicationState.getInstance().getVolume();
            for (int i = 0; i < 50 && n > 0; ++i) {
                n = (n -= 2) < 0 ? 0 : n;
                XineEngine.this.xineController.setVolume(n);
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            XineEngine.this.internalStop();
            XineEngine.this.xineController.setVolume(ApplicationState.getInstance().getVolume());
        }
    }
}

