/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player.mplayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.player.AbstractPlayerEngine;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.mplayer.AbstractMPlayerOutputReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.FadeAwayRunnable;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerCommandWriter;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerErrorReader;
import net.sourceforge.atunes.kernel.modules.player.mplayer.MPlayerPositionThread;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.ProxyBean;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.FileNameUtils;

public class MPlayerEngine
extends AbstractPlayerEngine {
    private static String LINUX_COMMAND = "mplayer";
    private static final String WIN_COMMAND = "win_tools/mplayer.exe";
    private static final String MACOS_COMMAND = "mac_tools/mplayer";
    private static final String SOLARIS_COMMAND = "mplayer";
    private static final String SOLARISOPTAO = "-ao";
    private static final String SOLARISOPTTYPE = "sun";
    private static final String WINOPTPRIORITY = "-priority";
    private static final String WINOPTPRIORITY_DEFAULT = "abovenormal";
    private static final String QUIET = "-quiet";
    private static final String SLAVE = "-slave";
    private static final String PLAYLIST = "-playlist";
    private static final String AUDIO_FILTER = "-af";
    private static final String VOLUME_NORM = "volnorm";
    private static final String KARAOKE = "karaoke";
    private static final String EQUALIZER = "equalizer=";
    private static final String CACHE = "-cache";
    private static final String CACHE_SIZE = "500";
    private static final String CACHE_MIN = "-cache-min";
    private static final String CACHE_FILL_SIZE_IN_PERCENT = "7.0";
    private static final String PREFER_IPV4 = "-prefer-ipv4";
    private Process process;
    private MPlayerCommandWriter commandWriter = new MPlayerCommandWriter(null);
    private AbstractMPlayerOutputReader mPlayerOutputReader;
    private MPlayerErrorReader mPlayerErrorReader;
    private MPlayerPositionThread mPlayerPositionThread;
    private FadeAwayRunnable currentFadeAwayRunnable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEngineAvailable() {
        if (SystemProperties.OS != SystemProperties.OperatingSystem.WINDOWS) {
            InputStream inputStream;
            block8: {
                boolean bl;
                inputStream = null;
                try {
                    Process process = new ProcessBuilder(LINUX_COMMAND).start();
                    inputStream = process.getInputStream();
                    byte[] byArray = new byte[4096];
                    while (inputStream.read(byArray) >= 0) {
                    }
                    int n = process.waitFor();
                    if (n == 0) break block8;
                    bl = false;
                }
                catch (Exception exception) {
                    block9: {
                        if (SystemProperties.OS != SystemProperties.OperatingSystem.MACOSX || LINUX_COMMAND.equals(MACOS_COMMAND)) break block9;
                        this.getLogger().info("PLAYER      ", "Mac OS X: mplayer not found, trying in mac_tools");
                        LINUX_COMMAND = MACOS_COMMAND;
                        boolean bl2 = this.isEngineAvailable();
                        ClosingUtils.close(inputStream);
                        return bl2;
                    }
                    try {
                        boolean bl3 = false;
                        return bl3;
                    }
                    finally {
                        ClosingUtils.close(inputStream);
                    }
                }
                ClosingUtils.close(inputStream);
                return bl;
            }
            ClosingUtils.close(inputStream);
        }
        return true;
    }

    @Override
    protected void pausePlayback() {
        this.commandWriter.sendPauseCommand();
    }

    @Override
    protected void resumePlayback() {
        this.commandWriter.sendResumeCommand();
        if (!this.isMuteEnabled()) {
            this.commandWriter.sendVolumeCommand(ApplicationState.getInstance().getVolume());
        }
    }

    @Override
    protected void startPlayback(AudioObject audioObject, AudioObject audioObject2) {
        try {
            if (this.currentFadeAwayRunnable != null) {
                this.currentFadeAwayRunnable.finish();
            }
            this.commandWriter.sendStopCommand();
            this.process = this.getProcess(audioObject);
            this.commandWriter = new MPlayerCommandWriter(this.process);
            this.mPlayerOutputReader = AbstractMPlayerOutputReader.newInstance(this, this.process, audioObject2);
            this.mPlayerErrorReader = new MPlayerErrorReader(this, this.process, this.mPlayerOutputReader, audioObject);
            this.mPlayerOutputReader.start();
            this.mPlayerErrorReader.start();
            this.mPlayerPositionThread = new MPlayerPositionThread(this);
            this.mPlayerPositionThread.start();
            this.commandWriter.sendGetDurationCommand();
            this.setVolume(ApplicationState.getInstance().getVolume());
        }
        catch (Exception exception) {
            this.stopCurrentAudioObject(false);
            this.handlePlayerEngineError(exception);
        }
    }

    @Override
    protected void stopPlayback(boolean bl, boolean bl2) {
        if (!this.isEnginePlaying()) {
            return;
        }
        if (bl2 && !this.isPaused()) {
            if (this.currentFadeAwayRunnable != null) {
                return;
            }
            this.mPlayerErrorReader.interrupt();
            this.currentFadeAwayRunnable = new FadeAwayRunnable(this.process, ApplicationState.getInstance().getVolume(), this);
            Thread thread = new Thread(this.currentFadeAwayRunnable);
            thread.start();
        } else {
            this.commandWriter.sendStopCommand();
            if (this.currentFadeAwayRunnable != null) {
                this.currentFadeAwayRunnable.finish();
            } else {
                this.process = null;
                this.mPlayerErrorReader = null;
                this.mPlayerOutputReader = null;
                this.commandWriter.finishProcess();
                this.mPlayerPositionThread.interrupt();
                this.mPlayerPositionThread = null;
            }
            this.setCurrentAudioObjectPlayedTime(0L);
        }
    }

    protected void finishedFadeAway() {
        this.mPlayerOutputReader.interrupt();
        this.process = null;
        this.mPlayerErrorReader = null;
        this.mPlayerOutputReader = null;
        this.mPlayerPositionThread.interrupt();
        this.mPlayerPositionThread = null;
        this.commandWriter.finishProcess();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MPlayerEngine.this.setTime(0);
            }
        });
        this.currentFadeAwayRunnable = null;
    }

    protected void setTime(int n) {
        super.setCurrentAudioObjectPlayedTime(n);
    }

    @Override
    protected void seekTo(long l) {
        this.commandWriter.sendSeekCommand(l);
    }

    @Override
    public void finishPlayer() {
        this.stopCurrentAudioObject(false);
        this.getLogger().info("PLAYER      ", "Stopping player");
    }

    @Override
    public boolean isEnginePlaying() {
        return this.process != null && !this.isPaused();
    }

    @Override
    public void applyMuteState(boolean bl) {
        this.getLogger().debugMethodCall("PLAYER      ", Boolean.toString(bl));
        this.commandWriter.sendMuteCommand();
        this.setVolume(ApplicationState.getInstance().getVolume());
        if (this.isPaused() && !bl) {
            this.commandWriter.sendPauseCommand();
            this.getLogger().debug("PLAYER      ", "MPlayer bug (paused, demute, muted -> starts playing) workaround applied");
        }
    }

    @Override
    public void setVolume(int n) {
        if (!this.isPaused() && !this.isMuteEnabled()) {
            this.commandWriter.sendVolumeCommand(n);
        }
    }

    private Process getProcess(AudioObject audioObject) throws IOException {
        Object object;
        CharSequence charSequence;
        String string;
        boolean bl;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = !(audioObject instanceof AudioFile) && (!(audioObject instanceof PodcastFeedEntry) || !ApplicationState.getInstance().isUseDownloadedPodcastFeedEntries() || !((PodcastFeedEntry)audioObject).isDownloaded());
        arrayList.add(this.getProcessNameForOS());
        if (SystemProperties.OS == SystemProperties.OperatingSystem.SOLARIS) {
            arrayList.add(SOLARISOPTAO);
            arrayList.add(SOLARISOPTTYPE);
        } else if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            arrayList.add(WINOPTPRIORITY);
            arrayList.add(WINOPTPRIORITY_DEFAULT);
        }
        arrayList.add(QUIET);
        arrayList.add(SLAVE);
        if (bl2) {
            arrayList.add(PREFER_IPV4);
        }
        if (audioObject instanceof Radio && ((Radio)audioObject).hasPlaylistUrl(Proxy.getProxy(ApplicationState.getInstance().getProxy()))) {
            arrayList.add(PLAYLIST);
        }
        boolean bl3 = bl = ApplicationState.getInstance().isUseShortPathNames() && SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS && audioObject instanceof AudioFile;
        if (audioObject instanceof PodcastFeedEntry && !bl2) {
            string = PodcastFeedHandler.getInstance().getDownloadPath((PodcastFeedEntry)audioObject);
            if (ApplicationState.getInstance().isUseShortPathNames() && SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                bl = true;
            }
        } else {
            string = audioObject.getUrl();
        }
        if (bl) {
            charSequence = FileNameUtils.getShortPathNameW(string);
            arrayList.add((String)(charSequence != null && !((String)charSequence).isEmpty() ? charSequence : string));
        } else if (string.startsWith("http")) {
            charSequence = new StringBuilder();
            object = ApplicationState.getInstance().getProxy();
            if (object != null && ((ProxyBean)object).getType().equals("HTTP_PROXY")) {
                String string2 = ((ProxyBean)object).getUrl();
                int n = ((ProxyBean)object).getPort();
                ((StringBuilder)charSequence).append("http_proxy://");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(n != 0 ? ":" : "");
                ((StringBuilder)charSequence).append(n != 0 ? Integer.valueOf(n) : "");
                ((StringBuilder)charSequence).append("/");
            }
            ((StringBuilder)charSequence).append(string);
            arrayList.add(((StringBuilder)charSequence).toString());
        } else {
            arrayList.add(string);
        }
        if (bl2) {
            arrayList.add(CACHE);
            arrayList.add(CACHE_SIZE);
            arrayList.add(CACHE_MIN);
            arrayList.add(CACHE_FILL_SIZE_IN_PERCENT);
        }
        boolean bl4 = ApplicationState.getInstance().isKaraoke();
        if (audioObject instanceof AudioFile && this.getEqualizer().getEqualizerValues() != null || this.isSoundNormalizationEnabled() || bl4) {
            arrayList.add(AUDIO_FILTER);
        }
        if (this.isSoundNormalizationEnabled()) {
            arrayList.add(VOLUME_NORM);
        }
        if (audioObject instanceof AudioFile && this.getEqualizer().getEqualizerValues() != null && !bl4) {
            object = this.getEqualizer().getEqualizerValues();
            arrayList.add(EQUALIZER + (float)object[0] + ":" + (float)object[1] + ":" + (float)object[2] + ":" + (float)object[3] + ":" + (float)object[4] + ":" + (float)object[5] + ":" + (float)object[6] + ":" + (float)object[7] + ":" + (float)object[8] + ":" + (float)object[9]);
        }
        if (bl4) {
            arrayList.add(KARAOKE);
        }
        this.getLogger().debugMethodCall("PLAYER      ", arrayList.toArray(new String[arrayList.size()]));
        return processBuilder.command(arrayList).start();
    }

    private String getProcessNameForOS() {
        if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
            return WIN_COMMAND;
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.LINUX) {
            return LINUX_COMMAND;
        }
        if (SystemProperties.OS == SystemProperties.OperatingSystem.SOLARIS) {
            return SOLARIS_COMMAND;
        }
        return MACOS_COMMAND;
    }

    MPlayerCommandWriter getCommandWriter() {
        return this.commandWriter;
    }

    @Override
    public boolean supportsCapability(PlayerEngineCapability playerEngineCapability) {
        return EnumSet.of(PlayerEngineCapability.EQUALIZER, new PlayerEngineCapability[]{PlayerEngineCapability.EQUALIZER_CHANGE, PlayerEngineCapability.STREAMING, PlayerEngineCapability.PROXY, PlayerEngineCapability.KARAOKE, PlayerEngineCapability.NORMALIZATION}).contains((Object)playerEngineCapability);
    }

    @Override
    public void applyEqualization(float[] fArray) {
        if (this.isEnginePlaying()) {
            this.restartPlayback();
        }
    }

    @Override
    public void applyNormalization() {
        if (this.isEnginePlaying()) {
            this.restartPlayback();
        }
    }

    @Override
    public float[] transformEqualizerValues(float[] fArray) {
        return fArray;
    }

    protected void setCurrentLength(long l) {
        super.setCurrentAudioObjectLength(l);
    }

    protected boolean isPlaybackPaused() {
        return this.isPaused();
    }

    protected void notifyRadioOrPodcastFeedEntry() {
        super.notifyRadioOrPodcastFeedEntryStarted();
    }

    protected boolean isMute() {
        return super.isMuteEnabled();
    }

    @Override
    protected String getEngineName() {
        return "MPlayer";
    }

    @Override
    protected void killPlayer() {
        this.commandWriter.sendStopCommand();
    }
}

