/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.player;

import java.awt.Cursor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.player.Equalizer;
import net.sourceforge.atunes.kernel.modules.player.PlaybackState;
import net.sourceforge.atunes.kernel.modules.player.PlaybackStateListener;
import net.sourceforge.atunes.kernel.modules.player.PlayerEngineCapability;
import net.sourceforge.atunes.kernel.modules.player.Volume;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.statistics.StatisticsHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.TempFolder;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public abstract class AbstractPlayerEngine
implements PlaybackStateListener {
    private Logger logger;
    private List<PlaybackStateListener> playbackStateListeners;
    private boolean callToPlaybackStateListenersDisabled = false;
    private boolean paused;
    private AudioObject audioObject;
    private long currentAudioObjectLength;
    private File lastFileCached;
    private SubmissionState submissionState = SubmissionState.NOT_SUBMITTED;
    private long currentAudioObjectPlayedTime;
    private Equalizer equalizer = new Equalizer();
    private Thread playAudioObjectThread;

    public abstract boolean isEnginePlaying();

    protected abstract boolean isEngineAvailable();

    protected abstract void startPlayback(AudioObject var1, AudioObject var2);

    protected abstract void pausePlayback();

    protected abstract void resumePlayback();

    protected abstract void stopPlayback(boolean var1, boolean var2);

    protected abstract void seekTo(long var1);

    public abstract void setVolume(int var1);

    public abstract void applyMuteState(boolean var1);

    public abstract void applyNormalization();

    public abstract boolean supportsCapability(PlayerEngineCapability var1);

    protected abstract void applyEqualization(float[] var1);

    protected abstract float[] transformEqualizerValues(float[] var1);

    protected abstract void finishPlayer();

    protected abstract String getEngineName();

    public final void addPlaybackStateListener(PlaybackStateListener playbackStateListener) {
        if (this.playbackStateListeners == null) {
            this.playbackStateListeners = new ArrayList<PlaybackStateListener>();
        }
        this.playbackStateListeners.add(playbackStateListener);
    }

    public final void removePlaybackStateListener(PlaybackStateListener playbackStateListener) {
        if (this.playbackStateListeners == null || !this.playbackStateListeners.contains(playbackStateListener)) {
            return;
        }
        this.playbackStateListeners.remove(playbackStateListener);
    }

    final void callPlaybackStateListeners(PlaybackState playbackState) {
        if (!this.isCallToPlaybackStateListenersDisabled()) {
            for (PlaybackStateListener playbackStateListener : this.playbackStateListeners) {
                playbackStateListener.playbackStateChanged(playbackState, this.audioObject);
            }
        }
    }

    @Override
    public void playbackStateChanged(PlaybackState playbackState, AudioObject audioObject) {
        this.getLogger().debug("PLAYER      ", new Object[]{"Playback state changed to:", playbackState});
        if (playbackState == PlaybackState.PLAY_FINISHED || playbackState == PlaybackState.PLAY_INTERRUPTED || playbackState == PlaybackState.STOPPED) {
            this.submitToLastFmAndUpdateStats();
        }
        if (playbackState == PlaybackState.STOPPED) {
            this.setCurrentAudioObjectPlayedTime(0L);
            if (this.playAudioObjectThread != null) {
                this.playAudioObjectThread.interrupt();
            }
        }
    }

    public final void playCurrentAudioObject(boolean bl) {
        if (this.isEnginePlaying() && bl) {
            try {
                this.paused = true;
                this.pausePlayback();
                this.getLogger().info("PLAYER      ", "Pause");
                this.callPlaybackStateListeners(PlaybackState.PAUSED);
            }
            catch (Exception exception) {
                this.handlePlayerEngineError(exception);
                this.stopCurrentAudioObject(false);
            }
        } else {
            AudioObject audioObject = null;
            try {
                if (this.paused && bl) {
                    if (!PlayListHandler.getInstance().getCurrentPlayList(false).isEmpty()) {
                        this.paused = false;
                        this.resumePlayback();
                        this.callPlaybackStateListeners(PlaybackState.RESUMING);
                        this.getLogger().info("PLAYER      ", "Resumed paused song");
                    }
                } else {
                    audioObject = PlayListHandler.getInstance().getCurrentAudioObjectFromVisiblePlayList();
                    if (audioObject != null) {
                        if (this.isEnginePlaying() || this.paused) {
                            this.stopCurrentAudioObject(false);
                        }
                        PlayListHandler.setVisiblePlayListActive();
                        PlayListHandler.getInstance().selectedAudioObjectHasChanged(audioObject);
                        this.playAudioObject(audioObject);
                    }
                }
            }
            catch (Exception exception) {
                this.handlePlayerEngineError(exception);
                this.stopCurrentAudioObject(false);
            }
        }
    }

    public final void stopCurrentAudioObject(boolean bl) {
        try {
            boolean bl2;
            boolean bl3 = bl2 = bl && ApplicationState.getInstance().isUseFadeAway() && !this.paused;
            if (this.paused) {
                this.paused = false;
            }
            this.stopPlayback(bl, bl2);
            this.callPlaybackStateListeners(PlaybackState.STOPPED);
            this.getLogger().info("PLAYER      ", "Stop");
        }
        catch (Exception exception) {
            this.handlePlayerEngineError(exception);
        }
    }

    final void playPreviousAudioObject() {
        this.callPlaybackStateListeners(PlaybackState.PLAY_INTERRUPTED);
        this.switchPlaybackTo(PlayListHandler.getInstance().getPreviousAudioObject(), false, false);
    }

    final void playNextAudioObject(boolean bl) {
        if (!bl) {
            this.callPlaybackStateListeners(PlaybackState.PLAY_INTERRUPTED);
        }
        this.switchPlaybackTo(PlayListHandler.getInstance().getNextAudioObject(), true, bl);
    }

    public final void currentAudioObjectFinished(boolean bl, String ... stringArray) {
        this.callPlaybackStateListeners(PlaybackState.PLAY_FINISHED);
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append(" ");
            }
            this.getLogger().info("PLAYER      ", StringUtils.getString("Playback finished with errors: ", stringBuilder.toString()));
            boolean bl2 = this.showPlaybackError(stringArray);
            this.applyUserSelection(bl2);
        } else {
            this.getLogger().info("PLAYER      ", "Playback finished");
            this.playNextAudioObject(true);
        }
    }

    private boolean showPlaybackError(String ... stringArray) {
        ShowPlaybackErrorRunnable showPlaybackErrorRunnable = new ShowPlaybackErrorRunnable(stringArray);
        if (SwingUtilities.isEventDispatchThread()) {
            showPlaybackErrorRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(showPlaybackErrorRunnable);
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().error("PLAYER      ", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.getLogger().error("PLAYER      ", invocationTargetException);
            }
        }
        return showPlaybackErrorRunnable.isIgnore();
    }

    private void applyUserSelection(boolean bl) {
        ApplyUserSelectionRunnable applyUserSelectionRunnable = new ApplyUserSelectionRunnable(this, bl);
        if (SwingUtilities.isEventDispatchThread()) {
            applyUserSelectionRunnable.run();
        } else {
            SwingUtilities.invokeLater(applyUserSelectionRunnable);
        }
    }

    public final void seekCurrentAudioObject(long l) {
        if (this.paused) {
            this.paused = false;
            if (!PlayListHandler.getInstance().getCurrentPlayList(false).isEmpty()) {
                this.callPlaybackStateListeners(PlaybackState.RESUMING);
                this.getLogger().info("PLAYER      ", "Resumed paused song");
            }
        }
        this.seekTo(l);
    }

    public final void volumeDown() {
        this.getLogger().debug("PLAYER      ");
        Volume.setVolume(ApplicationState.getInstance().getVolume() - 5);
    }

    public final void volumeUp() {
        this.getLogger().debug("PLAYER      ");
        Volume.setVolume(ApplicationState.getInstance().getVolume() + 5);
    }

    public final void handlePlayerEngineError(Exception exception) {
        this.getLogger().error("PLAYER      ", StringUtils.getString("Player Error: ", exception));
        this.getLogger().error("PLAYER      ", exception);
        SwingUtilities.invokeLater(new ShowErrorDialog(exception));
    }

    protected AbstractPlayerEngine() {
    }

    public Equalizer getEqualizer() {
        return this.equalizer;
    }

    protected final boolean isSoundNormalizationEnabled() {
        return ApplicationState.getInstance().isUseNormalisation();
    }

    protected abstract void killPlayer();

    protected final boolean isMuteEnabled() {
        return ApplicationState.getInstance().isMuteEnabled();
    }

    protected final void setCurrentAudioObjectLength(long l) {
        this.currentAudioObjectLength = l;
        ControllerProxy.getInstance().getPlayerControlsController().setAudioObjectLength(l);
        GuiHandler.getInstance().getFullScreenWindow().setAudioObjectLength(l);
    }

    protected final void setCurrentAudioObjectPlayedTime(long l) {
        long l2;
        this.currentAudioObjectPlayedTime = l2 = l;
        ControllerProxy.getInstance().getPlayerControlsController().setCurrentAudioObjectTimePlayed(l2, this.currentAudioObjectLength);
        GuiHandler.getInstance().getFullScreenWindow().setCurrentAudioObjectPlayedTime(l2, this.currentAudioObjectLength);
        if (this.submissionState == SubmissionState.NOT_SUBMITTED && (l2 > this.currentAudioObjectLength / 2L || l2 >= 240000L)) {
            this.submissionState = SubmissionState.PENDING;
        }
    }

    private void submitToLastFmAndUpdateStats() {
        if (this.submissionState == SubmissionState.PENDING && this.audioObject instanceof AudioFile) {
            LastFmService.getInstance().submitToLastFm((AudioFile)this.audioObject, this.currentAudioObjectPlayedTime / 1000L);
            StatisticsHandler.getInstance().setAudioFileStatistics((AudioFile)this.audioObject);
            if (GuiHandler.getInstance().isStatsDialogVisible()) {
                ControllerProxy.getInstance().getStatsDialogController().updateStats();
            }
            this.submissionState = SubmissionState.SUBMITTED;
        }
    }

    protected final boolean isPaused() {
        return this.paused;
    }

    protected final void notifyRadioOrPodcastFeedEntryStarted() {
        this.getLogger().debug("PLAYER      ", "radio or podcast feed entry has started playing");
        this.setVolume(ApplicationState.getInstance().getVolume());
        if (ApplicationState.getInstance().isMuteEnabled()) {
            this.applyMuteState(true);
        }
        this.getLogger().debug("PLAYER      ", "MPlayer bug (ignoring muting and volume settings after streamed file starts playing) workaround applied");
    }

    protected void initializePlayerEngine() {
        this.getLogger().debug("PLAYER      ");
    }

    private void playAudioObject(AudioObject audioObject) {
        this.getLogger().info("PLAYER      ", StringUtils.getString("Started play of file ", audioObject));
        if (ApplicationState.getInstance().isCacheFilesBeforePlaying()) {
            PlayAudioObjectRunnable playAudioObjectRunnable = new PlayAudioObjectRunnable(audioObject);
            this.playAudioObjectThread = new Thread(playAudioObjectRunnable);
            this.playAudioObjectThread.start();
        } else {
            this.playAudioObjectAfterCache(audioObject, audioObject);
        }
    }

    private AudioObject cacheAudioObject(AudioObject audioObject) {
        AudioObject audioObject2 = null;
        if (audioObject instanceof AudioFile && ApplicationState.getInstance().isCacheFilesBeforePlaying()) {
            File file;
            this.getLogger().debug("PLAYER      ", "Start caching file: ", audioObject.getUrl());
            if (this.lastFileCached != null) {
                TempFolder.getInstance().removeFile(this.lastFileCached);
            }
            if ((file = TempFolder.getInstance().copyToTempFolder(((AudioFile)audioObject).getFile())) != null) {
                audioObject2 = new AudioFile(file);
                this.lastFileCached = file;
            } else {
                this.lastFileCached = null;
            }
            this.getLogger().debug("PLAYER      ", "End caching file: ", audioObject.getUrl());
        } else {
            audioObject2 = audioObject;
        }
        return audioObject2;
    }

    private void playAudioObjectAfterCache(AudioObject audioObject, AudioObject audioObject2) {
        this.submissionState = SubmissionState.NOT_SUBMITTED;
        if (audioObject2 instanceof PodcastFeedEntry) {
            ((PodcastFeedEntry)audioObject2).setListened(true);
            NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
        }
        if (audioObject2 instanceof AudioFile) {
            LastFmService.getInstance().submitNowPlayingInfoToLastFm((AudioFile)audioObject2);
        }
        this.audioObject = audioObject2;
        PlayListHandler.getInstance().addToPlaybackHistory(audioObject2);
        this.startPlayback(audioObject, audioObject2);
        if (ApplicationState.getInstance().isMuteEnabled()) {
            this.applyMuteState(true);
        } else {
            this.setVolume(ApplicationState.getInstance().getVolume());
        }
        this.callPlaybackStateListeners(PlaybackState.PLAYING);
    }

    private void switchPlaybackTo(AudioObject audioObject, boolean bl, boolean bl2) {
        block6: {
            if (audioObject != null) {
                try {
                    PlayListHandler.getInstance().selectedAudioObjectHasChanged(audioObject);
                    if (!this.isEnginePlaying() && !this.isPaused() && !bl2) break block6;
                    this.stopCurrentAudioObject(false);
                    if (!this.isPaused()) {
                        this.playAudioObject(audioObject);
                    }
                }
                catch (Exception exception) {
                    this.handlePlayerEngineError(exception);
                    this.stopCurrentAudioObject(false);
                }
            } else if (bl) {
                this.stopCurrentAudioObject(false);
                PlayListHandler.getInstance().setPositionToPlayInCurrentPlayList(0);
                PlayListHandler.getInstance().selectedAudioObjectHasChanged(PlayListHandler.getInstance().getCurrentAudioObjectFromCurrentPlayList());
            }
        }
    }

    protected void restartPlayback() {
        long l = this.getCurrentAudioObjectPlayedTime();
        this.setCallToPlaybackStateListenersDisabled(true);
        this.finishPlayer();
        this.playCurrentAudioObject(true);
        this.seekCurrentAudioObject(l);
        this.setCallToPlaybackStateListenersDisabled(false);
    }

    public AudioObject getAudioObject() {
        return this.audioObject;
    }

    public long getCurrentAudioObjectPlayedTime() {
        return this.currentAudioObjectPlayedTime;
    }

    public long getCurrentAudioObjectLength() {
        return this.currentAudioObjectLength;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private boolean isCallToPlaybackStateListenersDisabled() {
        return this.callToPlaybackStateListenersDisabled;
    }

    private void setCallToPlaybackStateListenersDisabled(boolean bl) {
        this.callToPlaybackStateListenersDisabled = bl;
    }

    private static enum SubmissionState {
        NOT_SUBMITTED,
        PENDING,
        SUBMITTED;

    }

    private static final class ShowErrorDialog
    implements Runnable {
        private final Exception e;

        private ShowErrorDialog(Exception exception) {
            this.e = exception;
        }

        @Override
        public void run() {
            GuiHandler.getInstance().showErrorDialog(this.e.getMessage());
        }
    }

    private static final class ShowPlaybackErrorRunnable
    implements Runnable {
        private final String[] errorMessages;
        private boolean ignore;

        private ShowPlaybackErrorRunnable(String[] stringArray) {
            this.errorMessages = stringArray;
        }

        @Override
        public void run() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.errorMessages) {
                stringBuilder.append(string).append(" ");
            }
            String string = (String)GuiHandler.getInstance().showMessage(StringUtils.getString(stringBuilder.toString()), I18nUtils.getString("ERROR"), 0, new String[]{I18nUtils.getString("IGNORE"), I18nUtils.getString("CANCEL")});
            this.ignore = string.equals(I18nUtils.getString("IGNORE"));
        }

        protected boolean isIgnore() {
            return this.ignore;
        }
    }

    private static final class ApplyUserSelectionRunnable
    implements Runnable {
        private AbstractPlayerEngine engine;
        private final boolean ignorePlaybackError;

        private ApplyUserSelectionRunnable(AbstractPlayerEngine abstractPlayerEngine, boolean bl) {
            this.engine = abstractPlayerEngine;
            this.ignorePlaybackError = bl;
        }

        @Override
        public void run() {
            if (this.ignorePlaybackError) {
                this.engine.playNextAudioObject(true);
            } else {
                this.engine.stopCurrentAudioObject(false);
            }
        }
    }

    private final class PlayAudioObjectRunnable
    implements Runnable {
        private final AudioObject audioObject;
        AudioObject audioObjectToPlay = null;

        private PlayAudioObjectRunnable(AudioObject audioObject) {
            this.audioObject = audioObject;
            GuiHandler.getInstance().getFrame().getFrame().setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public void run() {
            this.audioObjectToPlay = AbstractPlayerEngine.this.cacheAudioObject(this.audioObject);
            GuiHandler.getInstance().getFrame().getFrame().setCursor(Cursor.getDefaultCursor());
            AbstractPlayerEngine.this.playAudioObjectAfterCache(this.audioObjectToPlay, this.audioObject);
            AbstractPlayerEngine.this.playAudioObjectThread = null;
        }
    }
}

