/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.similar;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanelContent;
import net.sourceforge.atunes.kernel.modules.context.ArtistInfo;
import net.sourceforge.atunes.kernel.modules.context.ContextImageJTable;
import net.sourceforge.atunes.kernel.modules.context.SimilarArtistsInfo;
import net.sourceforge.atunes.kernel.modules.context.similar.SimilarArtistsDataSource;
import net.sourceforge.atunes.kernel.modules.context.similar.SimilarArtistsTableModel;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class SimilarArtistsContent
extends AbstractContextPanelContent {
    private static final long serialVersionUID = 5041098100868186051L;
    private ContextImageJTable similarArtistsTable;

    public SimilarArtistsContent() {
        super(new SimilarArtistsDataSource());
    }

    @Override
    protected String getContentName() {
        return I18nUtils.getString("SIMILAR");
    }

    @Override
    protected Map<String, ?> getDataSourceParameters(AudioObject audioObject) {
        HashMap<String, AudioObject> hashMap = new HashMap<String, AudioObject>();
        hashMap.put("AUDIO_OBJECT", audioObject);
        return hashMap;
    }

    @Override
    protected void updateContentWithDataSourceResult(Map<String, ?> map) {
        if (map.containsKey("ARTISTS")) {
            this.similarArtistsTable.setModel(new SimilarArtistsTableModel(((SimilarArtistsInfo)map.get("ARTISTS")).getArtists()));
        }
    }

    @Override
    protected void clearContextPanelContent() {
        super.clearContextPanelContent();
        this.similarArtistsTable.setModel(new SimilarArtistsTableModel(null));
    }

    @Override
    protected Component getComponent() {
        this.similarArtistsTable = new ContextImageJTable();
        this.similarArtistsTable.setSelectionMode(0);
        this.similarArtistsTable.setShowGrid(false);
        this.similarArtistsTable.setDefaultRenderer(ArtistInfo.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new SimilarArtistTableCellRendererCode()));
        this.similarArtistsTable.setColumnSelectionAllowed(false);
        this.similarArtistsTable.setAutoResizeMode(3);
        this.similarArtistsTable.getTableHeader().setReorderingAllowed(false);
        this.similarArtistsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = SimilarArtistsContent.this.similarArtistsTable.getSelectedRow()) != -1) {
                    ArtistInfo artistInfo = ((SimilarArtistsTableModel)SimilarArtistsContent.this.similarArtistsTable.getModel()).getArtist(n);
                    DesktopUtils.openURL(artistInfo.getUrl());
                }
            }
        });
        return this.similarArtistsTable;
    }

    private static class SimilarArtistTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private SimilarArtistTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return SimilarArtistsContent.getPanelForTableRenderer(((ArtistInfo)object).getImage(), StringUtils.getString("<html><br>", ((ArtistInfo)object).getName(), "<br>", ((ArtistInfo)object).getMatch(), "%<br>", ((ArtistInfo)object).isAvailable() ? I18nUtils.getString("AVAILABLE_IN_REPOSITORY") : "", "</html>"), component.getBackground(), 75, 75);
        }
    }
}

