/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.context.album;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.modules.context.AlbumInfo;
import net.sourceforge.atunes.kernel.modules.context.ContextInformationDataSource;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.ImageSize;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;

public class AlbumInfoDataSource
implements ContextInformationDataSource {
    public static final String INPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String INPUT_BOOLEAN_IMAGE = "IMAGE";
    public static final String OUTPUT_AUDIO_OBJECT = "AUDIO_OBJECT";
    public static final String OUTPUT_IMAGE = "IMAGE";
    public static final String OUTPUT_ALBUM = "ALBUM";

    @Override
    public Map<String, ?> getData(Map<String, ?> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map.containsKey("AUDIO_OBJECT")) {
            AudioObject audioObject = (AudioObject)map.get("AUDIO_OBJECT");
            hashMap.put("AUDIO_OBJECT", audioObject);
            AlbumInfo albumInfo = this.getAlbumInfo(audioObject);
            if (albumInfo != null) {
                hashMap.put(OUTPUT_ALBUM, albumInfo);
                if (map.containsKey("IMAGE")) {
                    hashMap.put("IMAGE", this.getImage(albumInfo, audioObject));
                }
            }
        }
        return hashMap;
    }

    private AlbumInfo getAlbumInfo(AudioObject audioObject) {
        String string = audioObject.getAlbumArtist().isEmpty() ? audioObject.getArtist() : audioObject.getAlbumArtist();
        Serializable serializable = LastFmService.getInstance().getAlbum(string, audioObject.getAlbum());
        if (serializable == null) {
            Serializable serializable2;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List<AlbumInfo> list = null;
            if (!audioObject.getArtist().equals(I18nUtils.getString("UNKNOWN_ARTIST")) && (serializable2 = LastFmService.getInstance().getAlbumList(audioObject.getArtist(), ApplicationState.getInstance().isHideVariousArtistsAlbums(), ApplicationState.getInstance().getMinimumSongNumberPerAlbum())) != null) {
                list = serializable2.getAlbums();
            }
            if (list != null) {
                serializable2 = null;
                for (int i = 0; serializable2 == null && i < list.size(); ++i) {
                    AlbumInfo albumInfo = list.get(i);
                    StringTokenizer stringTokenizer = new StringTokenizer(albumInfo.getTitle(), " ");
                    boolean bl = true;
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens() && bl) {
                        String string2 = stringTokenizer.nextToken();
                        if (this.forbiddenToken(string2)) {
                            bl = false;
                            break;
                        }
                        if (!this.validToken(string2)) {
                            if (n != 0 || stringTokenizer.hasMoreTokens()) continue;
                            bl = false;
                        }
                        if (!audioObject.getAlbum().toLowerCase().contains(string2.toLowerCase())) {
                            bl = false;
                        }
                        ++n;
                    }
                    if (!bl) continue;
                    serializable2 = albumInfo;
                }
                if (serializable2 != null && (serializable2 = LastFmService.getInstance().getAlbum(serializable2.getArtist(), serializable2.getTitle())) != null) {
                    serializable = serializable2;
                }
            }
        }
        return serializable;
    }

    private Image getImage(AlbumInfo albumInfo, AudioObject audioObject) {
        Image image = null;
        if (albumInfo != null) {
            image = LastFmService.getInstance().getImage(albumInfo);
            if (audioObject instanceof AudioFile) {
                this.savePicture(image, (AudioFile)audioObject);
            }
        } else {
            image = audioObject.getImage(ImageSize.SIZE_MAX).getImage();
        }
        return image;
    }

    private void savePicture(Image image, AudioFile audioFile) {
        String string;
        File file;
        if (image != null && ApplicationState.getInstance().isSaveContextPicture() && !(file = new File(string = AudioFilePictureUtils.getFileNameForCover(audioFile))).exists()) {
            try {
                ImageUtils.writeImageToFile(image, string);
                RepositoryHandler.getInstance().addExternalPictureForAlbum(audioFile.getArtist(), audioFile.getAlbum(), file);
                ControllerProxy.getInstance().getFilePropertiesController().refreshPicture();
            }
            catch (IOException iOException) {
                new Logger().internalError(iOException);
            }
        }
    }

    private boolean validToken(String string) {
        return string.matches("[A-Za-z]+");
    }

    private boolean forbiddenToken(String string) {
        return string.contains("/");
    }
}

