/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class SizeColumn
extends AbstractColumn {
    private static final long serialVersionUID = 6971729868799630776L;

    public SizeColumn() {
        super("SIZE", String.class);
        this.setWidth(100);
        this.setVisible(false);
        this.setAlignment(0);
    }

    @Override
    protected int ascendingCompare(AudioObject audioObject, AudioObject audioObject2) {
        long l = 0L;
        long l2 = 0L;
        if (audioObject instanceof AudioFile) {
            l = ((AudioFile)audioObject).getFile().length();
        }
        if (audioObject2 instanceof AudioFile) {
            l2 = ((AudioFile)audioObject2).getFile().length();
        }
        return Long.valueOf(l).compareTo(l2);
    }

    @Override
    public Object getValueFor(AudioObject audioObject) {
        if (audioObject instanceof Radio) {
            return "";
        }
        if (audioObject instanceof PodcastFeedEntry) {
            return "";
        }
        return StringUtils.fromByteToMegaOrGiga(((AudioFile)audioObject).getFile().length());
    }
}

