/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.columns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.ColumnBean;
import net.sourceforge.atunes.kernel.modules.columns.ColumnSets;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;

public abstract class AbstractColumnSet {
    private List<AbstractColumn> availableColumns;
    private Map<Class<? extends AbstractColumn>, AbstractColumn> columnMap;
    private List<Class<? extends AbstractColumn>> currentColumns;
    private Logger logger;

    public AbstractColumnSet() {
        ColumnSets.registerColumnSet(this);
    }

    protected final Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private List<AbstractColumn> getAvailableColumns() {
        if (this.availableColumns == null) {
            Map<String, ColumnBean> map = this.getColumnsConfiguration();
            this.availableColumns = this.getAllowedColumns();
            this.columnMap = new HashMap<Class<? extends AbstractColumn>, AbstractColumn>();
            for (AbstractColumn abstractColumn : this.availableColumns) {
                this.columnMap.put(abstractColumn.getClass(), abstractColumn);
            }
            if (map != null) {
                for (AbstractColumn abstractColumn : this.availableColumns) {
                    ColumnBean columnBean = map.get(abstractColumn.getClass().getName());
                    if (columnBean == null) continue;
                    abstractColumn.applyColumnBean(columnBean);
                }
            }
        }
        return this.availableColumns;
    }

    protected abstract List<AbstractColumn> getAllowedColumns();

    public final void storeCurrentColumnSettings() {
        HashMap<String, ColumnBean> hashMap = new HashMap<String, ColumnBean>();
        for (AbstractColumn abstractColumn : this.getAvailableColumns()) {
            hashMap.put(abstractColumn.getClass().getName(), abstractColumn.getColumnBean());
        }
        this.setColumnsConfiguration(hashMap);
    }

    public final int getVisibleColumnCount() {
        int n = 0;
        for (AbstractColumn abstractColumn : this.getAvailableColumns()) {
            if (!abstractColumn.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public final List<AbstractColumn> getColumnsOrdered() {
        ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>(this.getAvailableColumns());
        Collections.sort(arrayList);
        return arrayList;
    }

    public final void setCurrentColumns() {
        int n = this.getVisibleColumnCount();
        if (n == 0) {
            return;
        }
        this.currentColumns = new ArrayList<Class<? extends AbstractColumn>>();
        for (AbstractColumn abstractColumn : this.getColumnsOrdered()) {
            if (!abstractColumn.isVisible()) continue;
            this.currentColumns.add(abstractColumn.getClass());
        }
    }

    private List<AbstractColumn> getColumnsForFilter() {
        ArrayList<AbstractColumn> arrayList = new ArrayList<AbstractColumn>();
        for (AbstractColumn abstractColumn : this.getAvailableColumns()) {
            if (!abstractColumn.isVisible() || !abstractColumn.isUsedForFilter()) continue;
            arrayList.add(abstractColumn);
        }
        return arrayList;
    }

    public final Class<? extends AbstractColumn> getColumnId(int n) {
        if (this.currentColumns == null) {
            this.setCurrentColumns();
        }
        return this.currentColumns.get(n);
    }

    public List<AbstractColumn> getColumnsForSelection() {
        return new ArrayList<AbstractColumn>(this.getAvailableColumns());
    }

    public AbstractColumn getColumn(Class<? extends AbstractColumn> clazz) {
        return this.columnMap.get(clazz);
    }

    public List<AudioObject> filterAudioObjects(List<AudioObject> list, String string) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        List<AbstractColumn> list2 = this.getColumnsForFilter();
        String string2 = string.toLowerCase();
        for (AudioObject audioObject : list) {
            if (!this.filterAudioObject(audioObject, list2, string2)) continue;
            arrayList.add(audioObject);
        }
        return arrayList;
    }

    private boolean filterAudioObject(AudioObject audioObject, List<AbstractColumn> list, String string) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < list.size()) {
            String string2;
            if ((string2 = list.get(n++).getValueForFilter(audioObject)) == null) continue;
            bl = string2.toLowerCase().contains(string);
        }
        return bl;
    }

    protected final void addNewColumn(AbstractColumn abstractColumn) {
        ColumnBean columnBean;
        abstractColumn.setOrder(this.getAvailableColumns().size());
        this.getAvailableColumns().add(abstractColumn);
        this.columnMap.put(abstractColumn.getClass(), abstractColumn);
        boolean bl = false;
        Map<String, ColumnBean> map = this.getColumnsConfiguration();
        if (map != null && (columnBean = map.get(abstractColumn.getClass().getName())) != null) {
            abstractColumn.applyColumnBean(columnBean);
            bl = true;
        }
        if (bl) {
            this.refreshColumns();
        }
    }

    public void removeColumn(Class<?> clazz) {
        AbstractColumn abstractColumn = this.columnMap.get(clazz);
        this.columnMap.remove(clazz);
        this.getAvailableColumns().remove(abstractColumn);
        this.refreshColumns();
    }

    public AbstractColumn getSortedColumn() {
        if (this.currentColumns != null) {
            for (Class<? extends AbstractColumn> clazz : this.currentColumns) {
                AbstractColumn abstractColumn = this.getColumn(clazz);
                if (abstractColumn.getColumnSort() == null) continue;
                return abstractColumn;
            }
        }
        return null;
    }

    protected abstract Map<String, ColumnBean> getColumnsConfiguration();

    protected abstract void setColumnsConfiguration(Map<String, ColumnBean> var1);

    protected abstract void refreshColumns();
}

