/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.encoders;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.ProgressListener;
import net.sourceforge.atunes.kernel.modules.cdripper.encoders.Encoder;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.DefaultTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.TagModifier;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class NeroAacEncoder
implements Encoder {
    public static final String FORMAT_NAME = "Nero_AAC";
    public static final String NERO_AAC = "neroAacEnc";
    public static final String IGNORE_LENGTH = "-ignorelength";
    public static final String INPUT = "-if";
    public static final String OUTPUT = "-of";
    public static final String QUALITY = "-q";
    public static final String VERSION = "-help";
    static final String[] NERO_AAC_QUALITY = new String[]{"0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1.0"};
    static final String DEFAULT_NERO_AAC_QUALITY = "0.4";
    private Logger logger;
    private ProgressListener listener;
    private Process p;
    private String albumArtist;
    private String album;
    private int year;
    private String genre;
    private String quality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testTool() {
        boolean bl;
        int n;
        BufferedReader bufferedReader = null;
        try {
            Process process = SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new ProcessBuilder(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, NERO_AAC), VERSION).start() : new ProcessBuilder(NERO_AAC, VERSION).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (bufferedReader.readLine() != null) {
            }
            n = process.waitFor();
            if (n != 0) {
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(File file, File file2, String string, int n, String string2, String string3) {
        boolean bl;
        int n2;
        this.getLogger().info("NERO ENCODER", StringUtils.getString("Mp4 encoding process started... ", file.getName(), " -> ", file2.getName()));
        BufferedReader bufferedReader = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, NERO_AAC));
            } else {
                arrayList.add(NERO_AAC);
            }
            arrayList.add(QUALITY);
            arrayList.add(this.quality);
            arrayList.add(INPUT);
            arrayList.add(file.getAbsolutePath());
            arrayList.add(OUTPUT);
            arrayList.add(file2.getAbsolutePath());
            this.p = new ProcessBuilder(arrayList).start();
            bufferedReader = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
            while (bufferedReader.readLine() != null) {
                if (this.listener == null) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NeroAacEncoder.this.listener.notifyProgress(-1);
                    }
                });
            }
            n2 = this.p.waitFor();
            if (n2 != 0) {
                this.getLogger().error("FAAC ENCODER", StringUtils.getString("Process returned code ", n2));
                boolean bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            try {
                AudioFile audioFile = new AudioFile(file2);
                DefaultTag defaultTag = new DefaultTag();
                defaultTag.setAlbum(this.album);
                defaultTag.setAlbumArtist(this.albumArtist);
                defaultTag.setArtist(string2);
                defaultTag.setComposer(string3);
                defaultTag.setYear(this.year);
                defaultTag.setGenre(this.genre);
                defaultTag.setTitle(string);
                defaultTag.setTrackNumber(n);
                TagModifier.setInfo(audioFile, defaultTag);
            }
            catch (Exception exception) {
                this.getLogger().error("NERO ENCODER", StringUtils.getString("Jaudiotagger: Process execution caused exception ", exception));
                boolean bl3 = false;
                ClosingUtils.close(bufferedReader);
                return bl3;
            }
            this.getLogger().info("NERO ENCODER", "Encoded ok!!");
            bl = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (Exception exception) {
            this.getLogger().error("NERO ENCODER", StringUtils.getString("Process execution caused exception ", exception));
            n2 = 0;
            return n2 != 0;
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl;
    }

    @Override
    public String getExtensionOfEncodedFiles() {
        return "m4a";
    }

    @Override
    public void setAlbum(String string) {
        this.album = string;
    }

    public void setAlbumArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setArtist(String string) {
        this.albumArtist = string;
    }

    @Override
    public void setGenre(String string) {
        this.genre = string;
    }

    @Override
    public void setListener(ProgressListener progressListener) {
        this.listener = progressListener;
    }

    @Override
    public void setQuality(String string) {
        this.quality = string;
    }

    @Override
    public void setYear(int n) {
        this.year = n;
    }

    @Override
    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    @Override
    public String[] getAvailableQualities() {
        return NERO_AAC_QUALITY;
    }

    @Override
    public String getDefaultQuality() {
        return DEFAULT_NERO_AAC_QUALITY;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

