/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.AbstractCdToWavConverter;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.utils.ClosingUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class Cdda2wav
extends AbstractCdToWavConverter {
    private static final String CDDA2WAV_COMMAND_STRING = "cdda2wav";
    private static final String ICEDAX_COMMAND_STRING = "icedax";
    private static final String SCAN_BUS = "-scanbus";
    private static final String SCANDEVICES = "--devices";
    private static final String ATA = "dev=ATA";
    private static final String DEVICE = "-D";
    private static final String LIST_TRACKS = "-J";
    private static final String GUI = "-g";
    private static final String NO_INFO_FILE = "-H";
    private static final String CDDB = "--cddb=1";
    private static final String PARANOIA = "-paranoia";
    private static final String TRACKS = "-t";
    private static final String VERBOSE = "-verbose-level=summary,toc,sectors,titles";
    private static final String VERSION = "--version";
    private static final String WAVFORMAT = "-output-format=wav";
    private static String converterCommand = "cdda2wav";
    private Logger logger;
    private int devNumber;
    private CDInfo cdRecursive;
    private String device;
    private boolean cdLoaded;
    private boolean doNotRepeatNoCdDialog = true;
    private boolean ata = false;
    private boolean useParanoia = false;
    private List<String> devices = new ArrayList<String>();
    private int devCounter = 1;

    Cdda2wav() {
        this.device = this.doScanBus().get(0);
    }

    /*
     * Exception decompiling
     */
    static boolean pTestTool() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Could not resolve type clashes
     */
    @Override
    public boolean cdda2wav(int n, File file) {
        boolean bl2;
        this.getLogger().info("CDDA2WAV    ", StringUtils.getString("Writing wav file for track ", n, " in file ", file.getName()));
        BufferedReader bufferedReader = null;
        try {
            int n2;
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, converterCommand));
            } else {
                arrayList.add(converterCommand);
            }
            if (this.device != null) {
                if (this.ata) {
                    string = StringUtils.getString(ATA, ":", this.getDriveId());
                    arrayList.add(string);
                } else {
                    arrayList.add(DEVICE);
                    arrayList.add(this.getDriveId());
                }
            }
            arrayList.add(WAVFORMAT);
            arrayList.add(StringUtils.getString(TRACKS, n));
            arrayList.add(NO_INFO_FILE);
            if (this.useParanoia) {
                this.getLogger().info("CDDA2WAV    ", "Using paranoia mode");
                arrayList.add(PARANOIA);
            }
            arrayList.add(file.getAbsolutePath());
            file.getParentFile().mkdirs();
            this.getLogger().debugMethodCall("CDDA2WAV    ", arrayList.toArray(new String[arrayList.size()]));
            this.setProcess(new ProcessBuilder(arrayList).start());
            bufferedReader = new BufferedReader(new InputStreamReader(this.getProcess().getErrorStream()));
            string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (this.getListener() == null || !string.matches(".*%.*")) continue;
                n2 = string.indexOf(37);
                bl2 = Integer.parseInt(string.substring(n2 - 3, n2).trim());
                SwingUtilities.invokeLater(new Runnable(bl2 ? 1 : 0){
                    final /* synthetic */ int val$percent;
                    {
                        this.val$percent = n;
                    }

                    @Override
                    public void run() {
                        Cdda2wav.this.getListener().notifyProgress(this.val$percent);
                    }
                });
            }
            n2 = this.getProcess().waitFor();
            if (n2 != 0) {
                this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process returned code ", n2));
                bl2 = false;
                ClosingUtils.close(bufferedReader);
                return bl2;
            }
            this.getLogger().info("CDDA2WAV    ", "Wav file ok!!");
            bl2 = true;
            ClosingUtils.close(bufferedReader);
        }
        catch (IOException iOException) {
            this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process execution caused exception ", iOException));
            boolean bl2 = false;
            return bl2;
        }
        catch (InterruptedException interruptedException) {
            this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process execution caused exception ", interruptedException));
            boolean bl3 = false;
            return bl3;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ClosingUtils.close(bufferedReader);
        }
        return bl2;
    }

    @Override
    public boolean cdda2wav(int n, File file, boolean bl) {
        this.useParanoia = bl;
        return this.cdda2wav(n, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> doScanBus() {
        int n;
        String string;
        List<String> list;
        String string2;
        ArrayList<String> arrayList;
        BufferedReader bufferedReader;
        this.getLogger().info("CDDA2WAV    ", StringUtils.getString("Scanning bus using ", converterCommand));
        if (converterCommand.equals(ICEDAX_COMMAND_STRING)) {
            bufferedReader = null;
            try {
                arrayList = new ArrayList<String>();
                if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                    arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, converterCommand));
                } else {
                    arrayList.add(converterCommand);
                }
                arrayList.add(SCANDEVICES);
                arrayList.add(NO_INFO_FILE);
                this.getLogger().debugMethodCall("CDDA2WAV    ", arrayList.toArray(new String[arrayList.size()]));
                this.setProcess(new ProcessBuilder(arrayList).start());
                bufferedReader = new BufferedReader(new InputStreamReader(this.getProcess().getInputStream()));
                string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains("dev=") || string2.contains("dev=help")) continue;
                    String string3 = string2.trim();
                    list = new StringTokenizer(string3, "'");
                    ((StringTokenizer)((Object)list)).nextToken();
                    string = ((StringTokenizer)((Object)list)).nextToken();
                    string = string.replace("\t", "");
                    ++this.devNumber;
                    this.devices.add(string);
                }
                n = this.getProcess().waitFor();
                if (n != 0) {
                    this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process returned code ", n));
                }
                this.getLogger().info("CDDA2WAV    ", StringUtils.getString("Found ", this.devices.size(), " devices with --device method"));
                ClosingUtils.close(bufferedReader);
            }
            catch (IOException iOException) {
                this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process execution caused exception ", iOException));
                List<String> list2 = null;
                return list2;
            }
            catch (InterruptedException interruptedException) {
                this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process execution caused exception ", interruptedException));
                List<String> list3 = null;
                return list3;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
        }
        if (this.devices.size() == 0) {
            bufferedReader = null;
            try {
                arrayList = new ArrayList();
                if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                    arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, converterCommand));
                } else {
                    arrayList.add(converterCommand);
                }
                arrayList.add(SCAN_BUS);
                arrayList.add(NO_INFO_FILE);
                this.getLogger().debugMethodCall("CDDA2WAV    ", arrayList.toArray(new String[arrayList.size()]));
                this.setProcess(new ProcessBuilder(arrayList).start());
                bufferedReader = SystemProperties.OS == SystemProperties.OperatingSystem.LINUX && !converterCommand.equals(ICEDAX_COMMAND_STRING) || SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new BufferedReader(new InputStreamReader(this.getProcess().getErrorStream())) : new BufferedReader(new InputStreamReader(this.getProcess().getInputStream()));
                string2 = null;
                this.devNumber = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains("CD-ROM")) continue;
                    String string4 = string2.trim();
                    list = null;
                    if (SystemProperties.OS == SystemProperties.OperatingSystem.LINUX && !converterCommand.equals(ICEDAX_COMMAND_STRING) || SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                        try {
                            list = string4.substring(0, string4.indexOf("\t"));
                            list = ((String)((Object)list)).replace("\t", "");
                        }
                        catch (Exception exception) {
                            list = string4.substring(0, string4.indexOf(32));
                            list = ((String)((Object)list)).replace(" ", "");
                        }
                    } else {
                        list = string4.substring(0, string4.indexOf("\t"));
                        list = ((String)((Object)list)).replace("\t", "");
                    }
                    ++this.devNumber;
                    if (SystemProperties.OS == SystemProperties.OperatingSystem.SOLARIS) {
                        this.getLogger().info("CDDA2WAV    ", "Operating System is " + SystemProperties.OS.toString() + ", adjusting device path");
                        string = null;
                        Scanner scanner = new Scanner((String)((Object)list)).useDelimiter(",");
                        string = "/dev/rdsk/c" + scanner.nextInt();
                        string = string + "t" + scanner.nextInt();
                        string = string + "d" + scanner.nextInt();
                        string = string + "s2";
                        this.getLogger().info("CDDA2WAV    ", "device found is " + string);
                        this.devices.add(string);
                        continue;
                    }
                    this.devices.add((String)((Object)list));
                }
                n = this.getProcess().waitFor();
                if (n != 0) {
                    this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process returned code ", n));
                }
                this.getLogger().info("CDDA2WAV    ", StringUtils.getString("Found ", this.devices.size(), " devices with scanbus method"));
                ClosingUtils.close(bufferedReader);
            }
            catch (Exception exception) {
                this.getLogger().error("CDDA2WAV    ", "Process execution caused exception " + exception);
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
        }
        if (this.devices.size() == 0) {
            bufferedReader = null;
            try {
                arrayList = new ArrayList();
                if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                    arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, converterCommand));
                } else {
                    arrayList.add(converterCommand);
                }
                arrayList.add(SCAN_BUS);
                arrayList.add(ATA);
                arrayList.add(NO_INFO_FILE);
                this.getLogger().debugMethodCall("CDDA2WAV    ", arrayList.toArray(new String[arrayList.size()]));
                this.setProcess(new ProcessBuilder(arrayList).start());
                bufferedReader = SystemProperties.OS == SystemProperties.OperatingSystem.LINUX && !converterCommand.equals(ICEDAX_COMMAND_STRING) || SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS ? new BufferedReader(new InputStreamReader(this.getProcess().getErrorStream())) : new BufferedReader(new InputStreamReader(this.getProcess().getInputStream()));
                string2 = null;
                this.devNumber = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.contains("CD-ROM")) continue;
                    String string5 = string2.trim();
                    list = null;
                    if (SystemProperties.OS == SystemProperties.OperatingSystem.LINUX && !converterCommand.equals(ICEDAX_COMMAND_STRING)) {
                        try {
                            list = string5.substring(0, string5.indexOf("\t"));
                            list = ((String)((Object)list)).replace("\t", "");
                        }
                        catch (Exception exception) {
                            list = string5.substring(0, string5.indexOf(32));
                            list = ((String)((Object)list)).replace(" ", "");
                        }
                    } else {
                        list = string5.substring(0, string5.indexOf("\t"));
                        list = ((String)((Object)list)).replace("\t", "");
                    }
                    ++this.devNumber;
                    this.devices.add((String)((Object)list));
                    this.ata = true;
                }
                int n2 = this.getProcess().waitFor();
                if (n2 != 0) {
                    this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process returned code ", n2));
                }
                this.getLogger().info("CDDA2WAV    ", StringUtils.getString("Found ", this.devices.size(), " devices with '-scanbus dev=ATA' method"));
                if (this.devices.size() == 0) {
                    this.devices.add(null);
                }
                list = this.devices;
                ClosingUtils.close(bufferedReader);
                return list;
            }
            catch (Exception exception) {
                this.getLogger().error("CDDA2WAV    ", StringUtils.getString("Process execution caused exception ", exception));
                string2 = null;
                return string2;
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
        }
        return this.devices;
    }

    @Override
    public CDInfo retrieveDiscInformation() {
        this.getLogger().info("CDDA2WAV    ", "Getting cd information...");
        this.cdRecursive = null;
        if (this.devNumber == 0) {
            return null;
        }
        try {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS) {
                arrayList.add(StringUtils.getString("win_tools", SystemProperties.FILE_SEPARATOR, converterCommand));
            } else {
                arrayList.add(converterCommand);
            }
            if (this.device != null) {
                if (this.ata) {
                    object = StringUtils.getString(ATA, ":", this.getDriveId());
                    arrayList.add((String)object);
                } else {
                    arrayList.add(DEVICE);
                    arrayList.add(this.getDriveId());
                }
            }
            arrayList.add(LIST_TRACKS);
            arrayList.add(VERBOSE);
            arrayList.add(GUI);
            arrayList.add(NO_INFO_FILE);
            arrayList.add(CDDB);
            this.getLogger().debugMethodCall("CDDA2WAV    ", arrayList.toArray(new String[arrayList.size()]));
            this.setProcess(new ProcessBuilder(arrayList).start());
            this.cdLoaded = false;
            object = new ReadCddaThread();
            ((Thread)object).start();
            ((Thread)object).join(650L);
            if (this.cdLoaded) {
                ((Thread)object).join(80000L);
            }
            this.getProcess().destroy();
            ((Thread)object).interrupt();
            this.getLogger().info("CDDA2WAV    ", "Interrupt");
            try {
                if (this.getCdInfo().getTracks() == 0 || !this.cdLoaded) {
                    ++this.devCounter;
                    this.devices.remove(0);
                    if (this.getDriveId() != null && this.devCounter <= this.devNumber) {
                        this.cdRecursive = this.retrieveDiscInformation();
                    }
                }
            }
            catch (Exception exception) {
                this.getLogger().error("CDDA2WAV    ", exception);
            }
            if (this.cdRecursive != null) {
                this.setCdInfo(this.cdRecursive);
            }
            if (!this.cdLoaded || this.getCdInfo().getTracks() == 0) {
                if (this.doNotRepeatNoCdDialog) {
                    this.notifyNoCd();
                }
                this.doNotRepeatNoCdDialog = false;
                return null;
            }
            this.getLogger().info("CDDA2WAV    ", StringUtils.getString("CD info: ", this.getCdInfo()));
            return this.getCdInfo();
        }
        catch (IOException iOException) {
            this.getLogger().error("CDDA2WAV    ", iOException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            this.getLogger().error("CDDA2WAV    ", interruptedException);
            return null;
        }
    }

    private String getDriveId() {
        if (!this.devices.isEmpty()) {
            return this.devices.get(0);
        }
        return null;
    }

    @Override
    public void notifyNoCd() {
        if (this.getNoCdListener() != null) {
            this.getNoCdListener().noCd();
        }
    }

    @Override
    public void stop() {
        this.getProcess().destroy();
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }

    private final class ReadCddaThread
    extends Thread {
        private ReadCddaThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(Cdda2wav.this.getProcess().getErrorStream(), "ISO8859_1"));
                Cdda2wav.this.getLogger().info("CDDA2WAV    ", "Trying to read cdda2wav stream");
                String string = null;
                int n = 0;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                boolean bl = false;
                while ((string = bufferedReader.readLine()) != null) {
                    CharSequence charSequence;
                    Object object;
                    Object object2;
                    String string7;
                    Cdda2wav.this.getLogger().info("CDDA2WAV    ", StringUtils.getString("While loop: ", string));
                    if (string.contains("bytes buffer memory requested")) {
                        Cdda2wav.this.cdLoaded = true;
                    }
                    if (string.contains("This disk has no audio tracks")) {
                        Cdda2wav.this.cdLoaded = false;
                    }
                    if (string.matches("Tracks:.*")) {
                        Cdda2wav.this.cdLoaded = true;
                        n = Integer.parseInt(string.substring(string.indexOf(58) + 1, string.indexOf(32)));
                        string2 = string.substring(string.indexOf(32) + 1);
                    } else if (string.matches("CDDB discid.*")) {
                        Cdda2wav.this.cdLoaded = true;
                        string3 = string.substring(string.indexOf(48));
                    }
                    if (string.matches(".cddb connect failed.*")) {
                        bl = true;
                    }
                    if (string.matches("Album title:.*") && !bl) {
                        Cdda2wav.this.cdLoaded = true;
                        string7 = string.trim();
                        string7 = string7.replaceAll("''", "' '");
                        object2 = new StringTokenizer(string7, "'");
                        if (((StringTokenizer)object2).hasMoreTokens()) {
                            ((StringTokenizer)object2).nextToken();
                        }
                        if (((StringTokenizer)object2).hasMoreTokens()) {
                            string4 = ((StringTokenizer)object2).nextToken();
                        }
                        object = null;
                        if (((StringTokenizer)object2).hasMoreElements()) {
                            object = ((StringTokenizer)object2).nextToken();
                        }
                        charSequence = new StringBuilder(string4);
                        while (((StringTokenizer)object2).hasMoreElements() && object != null && !((String)object).matches(" from ")) {
                            ((StringBuilder)charSequence).append((String)object);
                            object = ((StringTokenizer)object2).nextToken();
                        }
                        string4 = ((StringBuilder)charSequence).toString();
                        if (((StringTokenizer)object2).hasMoreTokens()) {
                            string5 = ((StringTokenizer)object2).nextToken();
                        }
                        charSequence = new StringBuilder(string5);
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            object = ((StringTokenizer)object2).nextToken();
                            ((StringBuilder)charSequence).append((String)object);
                        }
                        string5 = ((StringBuilder)charSequence).toString();
                    } else if (string.matches("T..:.*") && !string.matches("......................data.*") && !bl) {
                        Cdda2wav.this.cdLoaded = true;
                        string7 = string.substring(12, 18).trim();
                        arrayList.add(string7);
                        if (!bl) {
                            object2 = string.trim();
                            object = new StringTokenizer((String)(object2 = ((String)object2).replaceAll("''", "' '")), "'");
                            if (((StringTokenizer)object).hasMoreElements()) {
                                ((StringTokenizer)object).nextToken();
                            }
                            if (((StringTokenizer)object).hasMoreElements()) {
                                string6 = ((StringTokenizer)object).nextToken();
                            }
                            charSequence = null;
                            if (((StringTokenizer)object).hasMoreTokens()) {
                                charSequence = ((StringTokenizer)object).nextToken();
                            }
                            StringBuilder stringBuilder = new StringBuilder(string6);
                            while (((StringTokenizer)object).hasMoreTokens() && charSequence != null && !((String)charSequence).matches(" from ")) {
                                stringBuilder.append((String)charSequence);
                                charSequence = ((StringTokenizer)object).nextToken();
                            }
                            string6 = stringBuilder.toString();
                            string6 = string6 != null ? string6.trim() : null;
                            String string8 = string6 = string6 != null && !string6.equals("") ? string6.replace("\\", "'") : null;
                            if (string6 != null) {
                                arrayList2.add(string6);
                                arrayList3.add("");
                                arrayList4.add("");
                            }
                        }
                    }
                    if (!string.matches("......................data.*")) continue;
                    --n;
                }
                if (!bl) {
                    string5 = string5 != null ? string5.replace("\\", "'") : null;
                    string4 = string4 != null ? string4.replace("\\", "'") : null;
                }
                string5 = string5 != null ? string5.trim() : null;
                string4 = string4 != null ? string4.trim() : null;
                Cdda2wav.this.getCdInfo().setTracks(n);
                Cdda2wav.this.getCdInfo().setDurations(arrayList);
                Cdda2wav.this.getCdInfo().setDuration(string2);
                Cdda2wav.this.getCdInfo().setId(string3);
                if (string4 != null && !string4.equals("")) {
                    Cdda2wav.this.getCdInfo().setAlbum(string4);
                }
                if (string5 != null && !string5.equals("")) {
                    Cdda2wav.this.getCdInfo().setArtist(string5);
                }
                Cdda2wav.this.getCdInfo().setTitles(arrayList2);
                Cdda2wav.this.getCdInfo().setArtists(arrayList3);
                Cdda2wav.this.getCdInfo().setComposers(arrayList4);
                ClosingUtils.close(bufferedReader);
            }
            catch (Exception exception) {
                Cdda2wav.this.getLogger().error("CDDA2WAV    ", exception);
            }
            finally {
                ClosingUtils.close(bufferedReader);
            }
        }
    }
}

