/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.playerControls;

import java.awt.EventQueue;
import java.awt.Font;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.playerControls.PlayerControlsListener;
import net.sourceforge.atunes.kernel.controllers.playerControls.ProgressBarSeekListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListEventListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public final class PlayerControlsController
extends AbstractSimpleController<PlayerControlsPanel>
implements PlayListEventListener {
    private static final int SECONDS_10 = 10000;
    private static final int SECONDS_30 = 30000;
    private static final int MINUTES_1 = 60000;
    private static final int MINUTES_2 = 120000;
    private static final int MINUTES_5 = 300000;
    private static final int MINUTES_10 = 600000;
    private static final int MINUTES_30 = 1800000;

    public PlayerControlsController(PlayerControlsPanel playerControlsPanel) {
        super(playerControlsPanel);
        this.addBindings();
        this.addStateBindings();
        PlayListHandler.getInstance().addPlayListEventListener(this);
    }

    @Override
    protected void addBindings() {
        PlayerControlsListener playerControlsListener = new PlayerControlsListener((PlayerControlsPanel)this.getComponentControlled(), this);
        ProgressBarSeekListener progressBarSeekListener = new ProgressBarSeekListener(((PlayerControlsPanel)this.getComponentControlled()).getProgressBar());
        ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar().addMouseListener(progressBarSeekListener);
        ((PlayerControlsPanel)this.getComponentControlled()).getVolumeSlider().addMouseWheelListener(playerControlsListener);
    }

    @Override
    protected void addStateBindings() {
    }

    @Override
    protected void notifyReload() {
    }

    public void setAudioObjectLength(long l) {
        this.getLogger().debug("CONTROLLER  ", Long.toString(l));
        ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar().setMaximum((int)l);
        this.setupProgressTicks(l);
    }

    public void setPlaying(boolean bl) {
        ((PlayerControlsPanel)this.getComponentControlled()).setPlaying(bl);
    }

    public void setSlidable(boolean bl) {
        ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar().setEnabled(bl);
    }

    public void setCurrentAudioObjectTimePlayed(final long l, final long l2) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PlayerControlsController.this.setCurrentAudioObjectTimePlayedEDT(l, l2);
                }
            });
        } else {
            this.setCurrentAudioObjectTimePlayedEDT(l, l2);
        }
    }

    private void setCurrentAudioObjectTimePlayedEDT(long l, long l2) {
        long l3 = l2 - l;
        if (l == 0L) {
            ((PlayerControlsPanel)this.getComponentControlled()).getRemainingTime().setText(StringUtils.milliseconds2String(l));
        } else {
            ((PlayerControlsPanel)this.getComponentControlled()).getRemainingTime().setText(l3 > 0L ? StringUtils.getString("- ", StringUtils.milliseconds2String(l3)) : "-");
        }
        ((PlayerControlsPanel)this.getComponentControlled()).getTime().setText(StringUtils.milliseconds2String(l));
        ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar().setValue((int)l);
    }

    public void setVolume(int n) {
        ((PlayerControlsPanel)this.getComponentControlled()).getVolumeSlider().setValue(n);
        ((PlayerControlsPanel)this.getComponentControlled()).getVolumeLevel().setText(StringUtils.getString(String.valueOf(n), " %"));
    }

    public float getPostionInPercent() {
        JSlider jSlider = ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar();
        int n = jSlider.getMaximum();
        int n2 = jSlider.getValue();
        float f = 0.0f;
        if (n > 0 && n2 >= 0) {
            int n3 = n2 * 100 / n;
            f = (float)n3 / 100.0f;
        }
        return f;
    }

    private void setupProgressTicks(long l) {
        int n = 10000;
        int n2 = 30000;
        if (l > 600000L && l <= 1800000L) {
            n = 30000;
            n2 = 60000;
        } else if (l > 1800000L) {
            n = 60000;
            n2 = 300000;
        }
        JSlider jSlider = ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar();
        jSlider.setLabelTable(null);
        jSlider.setPaintTicks(ApplicationState.getInstance().isShowTicks());
        jSlider.setMajorTickSpacing(n2);
        jSlider.setMinorTickSpacing(n);
        this.setupTicksLabels(l);
    }

    private void setupTicksLabels(long l) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        int n = 0;
        while ((long)n < l) {
            if (l < 60000L) {
                if (n % 10000 == 0 && n != 0) {
                    hashtable.put(n, this.getLabelForDuration(n));
                }
            } else if (l > 60000L && l <= 600000L) {
                if (n % 60000 == 0 && n != 0) {
                    hashtable.put(n, this.getLabelForDuration(n));
                }
            } else if (l > 600000L && l <= 1800000L) {
                if (n % 120000 == 0 && n != 0) {
                    hashtable.put(n, this.getLabelForDuration(n));
                }
            } else if (n % 600000 == 0 && n != 0) {
                hashtable.put(n, this.getLabelForDuration(n));
            }
            ++n;
        }
        JSlider jSlider = ((PlayerControlsPanel)this.getComponentControlled()).getProgressBar();
        jSlider.setPaintLabels(ApplicationState.getInstance().isShowTicks() && hashtable.size() > 0);
        if (hashtable.size() > 0) {
            jSlider.setLabelTable(hashtable);
        }
    }

    private JLabel getLabelForDuration(int n) {
        String string = StringUtils.milliseconds2String(n);
        JLabel jLabel = new JLabel(string, 0);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFontName(), 2, Math.max(font.getSize() - 2, 8)));
        return jLabel;
    }

    @Override
    public void clear() {
    }

    @Override
    public void selectedAudioObjectChanged(AudioObject audioObject) {
        boolean bl = audioObject.isSeekable();
        if (bl && audioObject instanceof PodcastFeedEntry) {
            bl = ApplicationState.getInstance().isUseDownloadedPodcastFeedEntries();
        }
        this.setSlidable(bl);
    }
}

