/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.playList;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.menus.PlayListMenu;
import net.sourceforge.atunes.kernel.controllers.playList.PlayListController;

public final class PlayListListener
extends MouseAdapter
implements ListSelectionListener {
    private PlayListTable table;
    private PlayListController controller;

    protected PlayListListener(PlayListTable playListTable, PlayListController playListController) {
        this.table = playListTable;
        this.controller = playListController;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.table)) {
            if (mouseEvent.getClickCount() == 2) {
                this.controller.playSelectedAudioObject();
            } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
                int[] nArray = this.table.getSelectedRows();
                int n = this.table.rowAtPoint(mouseEvent.getPoint());
                boolean bl = false;
                for (int i = 0; !bl && i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    bl = true;
                }
                if (!bl) {
                    this.table.getSelectionModel().setSelectionInterval(n, n);
                }
                this.table.getMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PlayListMenu.updatePlayListMenuItems(this.table);
    }
}

