/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.navigation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.model.AbstractCommonColumnModel;
import net.sourceforge.atunes.gui.model.NavigationTableColumnModel;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.gui.renderers.ColumnRenderers;
import net.sourceforge.atunes.gui.views.controls.ColumnSetPopupMenu;
import net.sourceforge.atunes.gui.views.controls.ColumnSetRowSorter;
import net.sourceforge.atunes.gui.views.dialogs.ExtendedToolTip;
import net.sourceforge.atunes.gui.views.dialogs.SearchDialog;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTreePanel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.ShowAlbumsInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowArtistsInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowFoldersInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowGenresInNavigatorAction;
import net.sourceforge.atunes.kernel.actions.ShowYearsInNavigatorAction;
import net.sourceforge.atunes.kernel.controllers.model.AbstractController;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationTableMouseListener;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationTreeMouseListener;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationTreeToolTipListener;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumn;
import net.sourceforge.atunes.kernel.modules.columns.AbstractColumnSet;
import net.sourceforge.atunes.kernel.modules.columns.NavigatorColumnSet;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.internetsearch.Search;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.AlbumTreeGenerator;
import net.sourceforge.atunes.kernel.modules.navigator.ArtistTreeGenerator;
import net.sourceforge.atunes.kernel.modules.navigator.DeviceNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.FolderTreeGenerator;
import net.sourceforge.atunes.kernel.modules.navigator.GenreTreeGenerator;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.RepositoryNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.TreeGenerator;
import net.sourceforge.atunes.kernel.modules.navigator.YearTreeGenerator;
import net.sourceforge.atunes.kernel.modules.repository.AudioFilesRemovedListener;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.model.TreeObject;

public final class NavigationController
extends AbstractController
implements AudioFilesRemovedListener {
    private NavigationTreePanel navigationTreePanel;
    private NavigationTablePanel navigationTablePanel;
    private volatile Object currentExtendedToolTipContent;
    private ExtendedToolTip extendedToolTip;
    private JComponent popupMenuCaller;
    private AbstractCommonColumnModel columnModel;
    private ColumnSetPopupMenu columnSetPopupMenu;
    private Timer timer = new Timer(0, new ExtendedToolTipActionListener());

    public NavigationController(NavigationTreePanel navigationTreePanel, NavigationTablePanel navigationTablePanel) {
        this.navigationTreePanel = navigationTreePanel;
        this.navigationTablePanel = navigationTablePanel;
        this.addBindings();
        RepositoryHandler.getInstance().addAudioFilesRemovedListener(this);
    }

    public NavigationTreePanel getNavigationTreePanel() {
        return this.navigationTreePanel;
    }

    public NavigationTablePanel getNavigationTablePanel() {
        return this.navigationTablePanel;
    }

    @Override
    protected void addBindings() {
        NavigationTableModel navigationTableModel = new NavigationTableModel();
        this.navigationTablePanel.getNavigationTable().setModel(navigationTableModel);
        this.columnModel = new NavigationTableColumnModel(this.navigationTablePanel.getNavigationTable());
        this.navigationTablePanel.getNavigationTable().setColumnModel(this.columnModel);
        ColumnRenderers.addRenderers(this.navigationTablePanel.getNavigationTable(), this.columnModel);
        new ColumnSetRowSorter(this.navigationTablePanel.getNavigationTable(), navigationTableModel, this.columnModel);
        this.columnSetPopupMenu = new ColumnSetPopupMenu(this.navigationTablePanel.getNavigationTable(), this.columnModel);
        for (AbstractNavigationView object2 : NavigationHandler.getInstance().getNavigationViews()) {
            object2.getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    NavigationController.this.updateTableContent((JTree)treeSelectionEvent.getSource());
                }
            });
        }
        NavigationTreeMouseListener navigationTreeMouseListener = new NavigationTreeMouseListener(this);
        NavigationTreeToolTipListener navigationTreeToolTipListener = new NavigationTreeToolTipListener(this);
        for (AbstractNavigationView abstractNavigationView : NavigationHandler.getInstance().getNavigationViews()) {
            abstractNavigationView.getTree().addMouseListener(navigationTreeMouseListener);
            abstractNavigationView.getTree().addMouseListener(navigationTreeToolTipListener);
            abstractNavigationView.getTree().addMouseMotionListener(navigationTreeToolTipListener);
            abstractNavigationView.getTreeScrollPane().addMouseWheelListener(navigationTreeToolTipListener);
        }
        this.navigationTablePanel.getNavigationTable().addMouseListener(new NavigationTableMouseListener(this, this.navigationTablePanel));
        this.navigationTreePanel.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = NavigationController.this.navigationTreePanel.getTabbedPane().getSelectedIndex();
                if (n != -1 && n != NavigationHandler.getInstance().indexOf(NavigationHandler.getInstance().getViewByName(ApplicationState.getInstance().getNavigationView()))) {
                    NavigationController.this.setNavigationView(NavigationHandler.getInstance().getNavigationViews().get(n).getClass().getName());
                }
            }
        });
    }

    @Override
    protected void addStateBindings() {
    }

    public Timer getToolTipTimer() {
        return this.timer;
    }

    public ExtendedToolTip getExtendedToolTip() {
        if (this.extendedToolTip == null) {
            JDialog.setDefaultLookAndFeelDecorated(false);
            this.extendedToolTip = new ExtendedToolTip();
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        return this.extendedToolTip;
    }

    public List<AudioFile> getFilesSelectedInNavigator() {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        if (this.getPopupMenuCaller() instanceof JTable) {
            int[] nArray = this.navigationTablePanel.getNavigationTable().getSelectedRows();
            arrayList.addAll(((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).getAudioObjectsAt(nArray));
        } else if (this.getPopupMenuCaller() instanceof JTree) {
            TreePath[] treePathArray;
            for (TreePath treePath : treePathArray = NavigationHandler.getInstance().getCurrentView().getTree().getSelectionPaths()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof TreeObject)) continue;
                arrayList.addAll(ControllerProxy.getInstance().getNavigationController().getAudioObjectsForTreeNode(NavigationHandler.getInstance().getCurrentView().getClass(), defaultMutableTreeNode));
            }
        }
        return AudioFile.getAudioFiles(arrayList);
    }

    public boolean sameParentFile(Collection<? extends AudioFile> collection) {
        HashSet<File> hashSet = new HashSet<File>();
        for (AudioFile audioFile : collection) {
            hashSet.add(audioFile.getFile().getParentFile());
        }
        return hashSet.size() == 1;
    }

    public Object getCurrentExtendedToolTipContent() {
        return this.currentExtendedToolTipContent;
    }

    public AudioObject getAudioObjectInNavigationTable(int n) {
        return ((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).getAudioObjectAt(n);
    }

    public List<AudioObject> getAudioObjectsForTreeNode(Class<? extends AbstractNavigationView> clazz, DefaultMutableTreeNode defaultMutableTreeNode) {
        AbstractColumn abstractColumn;
        List<AudioObject> list = NavigationHandler.getInstance().getView(clazz).getAudioObjectForTreeNode(defaultMutableTreeNode, ApplicationState.getInstance().getViewMode(), FilterHandler.getInstance().isFilterSelected(NavigationHandler.getInstance().getTreeFilter()) ? FilterHandler.getInstance().getFilter() : null);
        AbstractColumnSet abstractColumnSet = NavigationHandler.getInstance().getCurrentView().getCustomColumnSet();
        if (abstractColumnSet == null) {
            abstractColumnSet = NavigatorColumnSet.getInstance();
        }
        if ((abstractColumn = abstractColumnSet.getSortedColumn()) != null) {
            Collections.sort(list, abstractColumn.getComparator(false));
        }
        return list;
    }

    public void notifyDeviceReload() {
        NavigationHandler.getInstance().getView(DeviceNavigationView.class).refreshView(ApplicationState.getInstance().getViewMode(), FilterHandler.getInstance().isFilterSelected(NavigationHandler.getInstance().getTreeFilter()) ? FilterHandler.getInstance().getFilter() : null);
    }

    @Override
    public void notifyReload() {
        NavigationHandler.getInstance().refreshCurrentView();
    }

    public void refreshTable() {
        ((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).refresh(0);
    }

    public void setCurrentExtendedToolTipContent(Object object) {
        this.currentExtendedToolTipContent = object;
        this.getExtendedToolTip().setSizeToFitImage(object instanceof TreeObject && ((TreeObject)object).isExtendedToolTipImageSupported());
    }

    public void setNavigationView(String string) {
        this.getLogger().debugMethodCall("CONTROLLER  ", string);
        Class<? extends AbstractNavigationView> clazz = NavigationHandler.getInstance().getViewByName(string);
        if (clazz == null) {
            clazz = RepositoryNavigationView.class;
        }
        ApplicationState.getInstance().setNavigationView(clazz.getName());
        int n = this.navigationTreePanel.getTabbedPane().getSelectedIndex();
        int n2 = NavigationHandler.getInstance().indexOf(clazz);
        if (n != n2 && n2 < this.navigationTreePanel.getTabbedPane().getTabCount()) {
            this.navigationTreePanel.getTabbedPane().setSelectedIndex(n2);
        }
        boolean bl = NavigationHandler.getInstance().getView(clazz).isViewModeSupported();
        Actions.getAction(ShowAlbumsInNavigatorAction.class).setEnabled(bl);
        Actions.getAction(ShowArtistsInNavigatorAction.class).setEnabled(bl);
        Actions.getAction(ShowFoldersInNavigatorAction.class).setEnabled(bl);
        Actions.getAction(ShowGenresInNavigatorAction.class).setEnabled(bl);
        Actions.getAction(ShowYearsInNavigatorAction.class).setEnabled(bl);
        boolean bl2 = NavigationHandler.getInstance().getView(clazz).isUseDefaultNavigatorColumnSet();
        AbstractColumnSet abstractColumnSet = null;
        abstractColumnSet = bl2 ? NavigatorColumnSet.getInstance() : NavigationHandler.getInstance().getView(clazz).getCustomColumnSet();
        ((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).setColumnSet(abstractColumnSet);
        ((NavigationTableColumnModel)this.navigationTablePanel.getNavigationTable().getColumnModel()).setColumnSet(abstractColumnSet);
        NavigationHandler.getInstance().refreshCurrentView();
        this.columnSetPopupMenu.enableArrangeColumns(bl2);
        JTree jTree = NavigationHandler.getInstance().getCurrentView().getTree();
        if (jTree.getSelectionPath() != null) {
            ((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).setSongs(this.getAudioObjectsForTreeNode(clazz, (DefaultMutableTreeNode)jTree.getSelectionPath().getLastPathComponent()));
        }
    }

    public void updateTableContent(JTree jTree) {
        if (!ApplicationState.getInstance().isShowNavigationTable()) {
            return;
        }
        if (jTree != NavigationHandler.getInstance().getCurrentView().getTree()) {
            return;
        }
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            List<AudioObject> list = new ArrayList<AudioObject>();
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                list.addAll(this.getAudioObjectsForTreeNode(NavigationHandler.getInstance().getViewByName(ApplicationState.getInstance().getNavigationView()), defaultMutableTreeNode));
            }
            list = this.filterNavigationTable(list);
            ((NavigationTableModel)this.navigationTablePanel.getNavigationTable().getModel()).setSongs(list);
        }
    }

    private List<AudioObject> filterNavigationTable(List<AudioObject> list) {
        if (!FilterHandler.getInstance().isFilterSelected(NavigationHandler.getInstance().getTableFilter())) {
            return list;
        }
        if (NavigationHandler.getInstance().getCurrentView().isUseDefaultNavigatorColumnSet()) {
            return NavigatorColumnSet.getInstance().filterAudioObjects(list, FilterHandler.getInstance().getFilter());
        }
        return NavigationHandler.getInstance().getCurrentView().getCustomColumnSet().filterAudioObjects(list, FilterHandler.getInstance().getFilter());
    }

    public Search openSearchDialog(SearchDialog searchDialog, boolean bl) {
        searchDialog.setSetAsDefaultVisible(bl);
        searchDialog.setVisible(true);
        return searchDialog.getResult();
    }

    public JComponent getPopupMenuCaller() {
        return this.popupMenuCaller;
    }

    public void setPopupMenuCaller(JComponent jComponent) {
        this.popupMenuCaller = jComponent;
    }

    @Override
    public void audioFilesRemoved(List<AudioFile> list) {
        this.notifyReload();
    }

    public static enum ViewMode {
        ARTIST,
        ALBUM,
        GENRE,
        FOLDER,
        YEAR;


        public TreeGenerator getTreeGenerator() {
            TreeGenerator treeGenerator = null;
            treeGenerator = this == YEAR ? new YearTreeGenerator() : (this == ARTIST ? new ArtistTreeGenerator() : (this == ALBUM ? new AlbumTreeGenerator() : (this == GENRE ? new GenreTreeGenerator() : new FolderTreeGenerator())));
            return treeGenerator;
        }
    }

    private final class ExtendedToolTipActionListener
    implements ActionListener {
        private ExtendedToolTipActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NavigationController.this.getExtendedToolTip().setVisible(true);
            Object object = NavigationController.this.currentExtendedToolTipContent;
            GetAndSetImageSwingWorker getAndSetImageSwingWorker = new GetAndSetImageSwingWorker(object);
            getAndSetImageSwingWorker.execute();
        }

        private final class GetAndSetImageSwingWorker
        extends SwingWorker<ImageIcon, Void> {
            private final Object currentObject;

            private GetAndSetImageSwingWorker(Object object) {
                this.currentObject = object;
            }

            @Override
            protected ImageIcon doInBackground() throws Exception {
                return ExtendedToolTip.getImage(this.currentObject);
            }

            @Override
            protected void done() {
                try {
                    if (NavigationController.this.currentExtendedToolTipContent != null && NavigationController.this.currentExtendedToolTipContent.equals(this.currentObject)) {
                        NavigationController.this.getExtendedToolTip().setImage((ImageIcon)this.get());
                    }
                }
                catch (InterruptedException interruptedException) {
                    NavigationController.this.getLogger().error("IMAGE       ", interruptedException);
                }
                catch (ExecutionException executionException) {
                    NavigationController.this.getLogger().error("IMAGE       ", executionException);
                }
            }
        }
    }
}

