/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.editTagDialog;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.gui.autocomplete.AutoCompleteDecorator;
import net.sourceforge.atunes.gui.views.dialogs.EditTagDialog;
import net.sourceforge.atunes.kernel.controllers.editTagDialog.EditTagDialogActionListener;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.modules.process.AbstractProcess;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.AbstractTag;
import net.sourceforge.atunes.kernel.modules.repository.tags.tag.EditTagInfo;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.EditTagsProcess;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.AudioFilePictureUtils;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public final class EditTagDialogController
extends AbstractSimpleController<EditTagDialog> {
    private List<AudioFile> audioFilesEditing;
    private byte[] newCover;
    private boolean coverEdited;

    public EditTagDialogController(EditTagDialog editTagDialog) {
        super(editTagDialog);
        this.addBindings();
        this.addStateBindings();
    }

    @Override
    protected void addBindings() {
        List<String> list = Arrays.asList(AbstractTag.genres);
        Collections.sort(list);
        ((EditTagDialog)this.getComponentControlled()).getGenreComboBox().setModel(new ListComboBoxModel(list));
        AutoCompleteDecorator.decorate(((EditTagDialog)this.getComponentControlled()).getGenreComboBox());
        EditTagDialogActionListener editTagDialogActionListener = new EditTagDialogActionListener(this, (EditTagDialog)this.getComponentControlled());
        ((EditTagDialog)this.getComponentControlled()).getOkButton().addActionListener(editTagDialogActionListener);
        ((EditTagDialog)this.getComponentControlled()).getCancelButton().addActionListener(editTagDialogActionListener);
        ((EditTagDialog)this.getComponentControlled()).getNextButton().addActionListener(editTagDialogActionListener);
        ((EditTagDialog)this.getComponentControlled()).getPrevButton().addActionListener(editTagDialogActionListener);
        ((EditTagDialog)this.getComponentControlled()).getCoverButton().addActionListener(editTagDialogActionListener);
        ((EditTagDialog)this.getComponentControlled()).getRemoveCoverButton().addActionListener(editTagDialogActionListener);
    }

    @Override
    protected void addStateBindings() {
    }

    public void editFiles(List<AudioFile> list) {
        Serializable serializable;
        if (list == null || list.isEmpty()) {
            return;
        }
        this.audioFilesEditing = list;
        ((EditTagDialog)this.getComponentControlled()).getCover().setIcon(null);
        ((EditTagDialog)this.getComponentControlled()).getCoverButton().setEnabled(false);
        ((EditTagDialog)this.getComponentControlled()).getRemoveCoverButton().setEnabled(false);
        this.newCover = null;
        this.coverEdited = false;
        List<Artist> list2 = RepositoryHandler.getInstance().getArtists();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Artist serializable32 : list2) {
            arrayList.add(serializable32.getName());
        }
        ((EditTagDialog)this.getComponentControlled()).getArtistTextField().setModel(new ListComboBoxModel(arrayList));
        AutoCompleteDecorator.decorate(((EditTagDialog)this.getComponentControlled()).getArtistTextField());
        List<Album> list3 = RepositoryHandler.getInstance().getAlbums();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator bl = list3.iterator();
        while (bl.hasNext()) {
            serializable = (Album)bl.next();
            if (arrayList2.contains(((Album)serializable).getName())) continue;
            arrayList2.add(((Album)serializable).getName());
        }
        ((EditTagDialog)this.getComponentControlled()).getAlbumTextField().setModel(new ListComboBoxModel(arrayList2));
        AutoCompleteDecorator.decorate(((EditTagDialog)this.getComponentControlled()).getAlbumTextField());
        ((EditTagDialog)this.getComponentControlled()).setTitleSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setCoverSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setAlbumArtistSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setArtistSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setTrackNumberSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setDiscNumberSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setYearSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setGenreSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setCommentSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setLyricsSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setAlbumSelected(false);
        ((EditTagDialog)this.getComponentControlled()).setComposerSelected(false);
        boolean bl2 = false;
        for (AudioFile audioFile : this.audioFilesEditing) {
            if (!audioFile.supportsInternalPicture()) continue;
            bl2 = true;
            break;
        }
        if (list.size() == 1) {
            ((EditTagDialog)this.getComponentControlled()).getTitleCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getAlbumArtistCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getArtistCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getTrackNumberCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getYearCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getDiscNumberCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getGenreCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getCommentCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getLyricsCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getAlbumCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getComposerCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().setEnabled(false);
            ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().setEnabled(false);
            if (bl2) {
                this.getEditTagDialog().getOkButton().setEnabled(false);
                ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().setSelected(true);
                new GetInsidePictureSwingWorker(list).execute();
            }
        } else {
            ((EditTagDialog)this.getComponentControlled()).getTitleCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getAlbumArtistCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getArtistCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getTrackNumberCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getYearCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getDiscNumberCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getGenreCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getCommentCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getLyricsCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getAlbumCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getComposerCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().setEnabled(true);
            ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().setEnabled(bl2);
        }
        serializable = new HashSet<String>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<Integer> hashSet5 = new HashSet<Integer>();
        HashSet<String> hashSet6 = new HashSet<String>();
        HashSet<String> hashSet7 = new HashSet<String>();
        HashSet<String> hashSet8 = new HashSet<String>();
        HashSet<String> hashSet9 = new HashSet<String>();
        HashSet<String> hashSet10 = new HashSet<String>();
        for (AudioFile audioFile : list) {
            AbstractTag abstractTag = audioFile.getTag();
            if (abstractTag == null) continue;
            serializable.add(abstractTag.getTitle());
            hashSet.add(abstractTag.getTrackNumber());
            hashSet2.add(abstractTag.getDiscNumber());
            hashSet3.add(abstractTag.getArtist());
            hashSet4.add(abstractTag.getAlbum());
            hashSet5.add(abstractTag.getYear());
            hashSet6.add(abstractTag.getComment());
            hashSet7.add(abstractTag.getGenre());
            hashSet8.add(abstractTag.getComposer());
            hashSet9.add(abstractTag.getLyrics());
            hashSet10.add(abstractTag.getAlbumArtist());
        }
        if (serializable.size() == 1 && !serializable.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getTitleTextField().setText((String)serializable.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setTitleSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getTitleTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setTitleSelected(list.size() == 1);
        }
        if (hashSet.size() == 1 && !hashSet.contains(0)) {
            ((EditTagDialog)this.getComponentControlled()).getTrackNumberTextField().setText(((Integer)hashSet.iterator().next()).toString());
            ((EditTagDialog)this.getComponentControlled()).setTrackNumberSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getTrackNumberTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setTrackNumberSelected(list.size() == 1);
        }
        if (hashSet2.size() == 1 && !hashSet2.contains(0)) {
            ((EditTagDialog)this.getComponentControlled()).getDiscNumberTextField().setText(((Integer)hashSet2.iterator().next()).toString());
            ((EditTagDialog)this.getComponentControlled()).setDiscNumberSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getDiscNumberTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setDiscNumberSelected(list.size() == 1);
        }
        if (hashSet3.size() == 1 && !hashSet3.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getArtistTextField().getEditor().setItem(hashSet3.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setArtistSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getArtistTextField().getEditor().setItem("");
            ((EditTagDialog)this.getComponentControlled()).setArtistSelected(list.size() == 1);
        }
        if (hashSet4.size() == 1 && !hashSet4.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getAlbumTextField().getEditor().setItem(hashSet4.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setAlbumSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getAlbumTextField().getEditor().setItem("");
            ((EditTagDialog)this.getComponentControlled()).setAlbumSelected(list.size() == 1);
        }
        if (hashSet5.size() == 1 && !hashSet5.contains(0)) {
            ((EditTagDialog)this.getComponentControlled()).getYearTextField().setText(String.valueOf(hashSet5.iterator().next()));
            ((EditTagDialog)this.getComponentControlled()).setYearSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getYearTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setYearSelected(list.size() == 1);
        }
        if (hashSet6.size() == 1 && !hashSet6.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getCommentTextArea().setText((String)hashSet6.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).getCommentTextArea().setCaretPosition(0);
            ((EditTagDialog)this.getComponentControlled()).setCommentSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getCommentTextArea().setText("");
            ((EditTagDialog)this.getComponentControlled()).setCommentSelected(list.size() == 1);
        }
        if (hashSet7.size() == 1 && !hashSet7.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getGenreComboBox().getEditor().setItem(hashSet7.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setGenreSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getGenreComboBox().getEditor().setItem("");
            ((EditTagDialog)this.getComponentControlled()).setGenreSelected(list.size() == 1);
        }
        if (hashSet9.size() == 1 && !hashSet9.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getLyricsTextArea().setText((String)hashSet9.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).getLyricsTextArea().setCaretPosition(0);
            ((EditTagDialog)this.getComponentControlled()).setLyricsSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getLyricsTextArea().setText("");
            ((EditTagDialog)this.getComponentControlled()).setLyricsSelected(list.size() == 1);
        }
        if (hashSet8.size() == 1 && !hashSet8.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getComposerTextField().setText((String)hashSet8.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setComposerSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getComposerTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setComposerSelected(list.size() == 1);
        }
        if (hashSet10.size() == 1 && !hashSet10.contains("")) {
            ((EditTagDialog)this.getComponentControlled()).getAlbumArtistTextField().setText((String)hashSet10.iterator().next());
            ((EditTagDialog)this.getComponentControlled()).setAlbumArtistSelected(true);
        } else {
            ((EditTagDialog)this.getComponentControlled()).getAlbumArtistTextField().setText("");
            ((EditTagDialog)this.getComponentControlled()).setAlbumArtistSelected(list.size() == 1);
        }
        if (list.size() == 1) {
            String string = list.get(0).getNameWithoutExtension();
            JTextField jTextField = this.getDialog().getTitleTextField();
            jTextField.addKeyListener(new TitleTextFieldKeyAdapter(jTextField, string));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditTagDialogController.this.getDialog().getTitleTextField().isEnabled()) {
                    EditTagDialogController.this.getDialog().getTitleTextField().setCaretPosition(0);
                    EditTagDialogController.this.getDialog().getTitleTextField().requestFocus();
                }
            }
        });
        ((EditTagDialog)this.getComponentControlled()).setVisible(true);
    }

    EditTagDialog getDialog() {
        return (EditTagDialog)this.getComponentControlled();
    }

    EditTagDialog getEditTagDialog() {
        return (EditTagDialog)this.getComponentControlled();
    }

    protected void editTag() {
        Object object;
        this.getLogger().debug("CONTROLLER  ");
        ((EditTagDialog)this.getComponentControlled()).setVisible(true);
        EditTagInfo editTagInfo = new EditTagInfo();
        if (!((EditTagDialog)this.getComponentControlled()).getTitleCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getTitleCheckBox().isSelected()) {
            editTagInfo.put("TITLE", ((EditTagDialog)this.getComponentControlled()).getTitleTextField().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getArtistCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getArtistCheckBox().isSelected()) {
            editTagInfo.put("ARTIST", ((EditTagDialog)this.getComponentControlled()).getArtistTextField().getSelectedItem());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getAlbumCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getAlbumCheckBox().isSelected()) {
            editTagInfo.put("ALBUM", ((EditTagDialog)this.getComponentControlled()).getAlbumTextField().getSelectedItem());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getYearCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getYearCheckBox().isSelected()) {
            editTagInfo.put("YEAR", ((EditTagDialog)this.getComponentControlled()).getYearTextField().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getCommentCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getCommentCheckBox().isSelected()) {
            editTagInfo.put("COMMENT", ((EditTagDialog)this.getComponentControlled()).getCommentTextArea().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getGenreCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getGenreCheckBox().isSelected()) {
            editTagInfo.put("GENRE", ((EditTagDialog)this.getComponentControlled()).getGenreComboBox().getSelectedItem());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getLyricsCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getLyricsCheckBox().isSelected()) {
            object = ((EditTagDialog)this.getComponentControlled()).getLyricsTextArea().getText();
            if (SystemProperties.OS.equals((Object)SystemProperties.OperatingSystem.WINDOWS)) {
                object = ((String)object).replaceAll("^[\r]\n", "\r\n");
            }
            editTagInfo.put("LYRICS", object);
        }
        if (!((EditTagDialog)this.getComponentControlled()).getComposerCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getComposerCheckBox().isSelected()) {
            editTagInfo.put("COMPOSER", ((EditTagDialog)this.getComponentControlled()).getComposerTextField().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getAlbumArtistCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getAlbumArtistCheckBox().isSelected()) {
            editTagInfo.put("ALBUM_ARTIST", ((EditTagDialog)this.getComponentControlled()).getAlbumArtistTextField().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getTrackNumberCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getTrackNumberCheckBox().isSelected()) {
            editTagInfo.put("TRACK", ((EditTagDialog)this.getComponentControlled()).getTrackNumberTextField().getText());
        }
        if (!((EditTagDialog)this.getComponentControlled()).getDiscNumberCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getDiscNumberCheckBox().isSelected()) {
            editTagInfo.put("DISC_NUMBER", ((EditTagDialog)this.getComponentControlled()).getDiscNumberTextField().getText());
        }
        if ((!((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().isEnabled() || ((EditTagDialog)this.getComponentControlled()).getCoverCheckBox().isSelected()) && this.coverEdited) {
            editTagInfo.put("COVER", this.newCover);
        }
        object = new EditTagsProcess(new ArrayList<AudioFile>(this.audioFilesEditing), editTagInfo);
        ((AbstractProcess)object).execute();
    }

    public void setNewCover(byte[] byArray) {
        this.newCover = byArray;
    }

    public void setCoverEdited(boolean bl) {
        this.coverEdited = bl;
    }

    public List<AudioFile> getAudioFilesEditing() {
        return new ArrayList<AudioFile>(this.audioFilesEditing);
    }

    public void clear() {
        this.audioFilesEditing = Collections.emptyList();
        this.newCover = null;
        this.coverEdited = false;
    }

    @Override
    protected void notifyReload() {
    }

    private static final class TitleTextFieldKeyAdapter
    extends KeyAdapter {
        private final JTextField textField;
        private final String fileName;
        private int lenght = 0;

        private TitleTextFieldKeyAdapter(JTextField jTextField, String string) {
            this.textField = jTextField;
            this.fileName = string;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n;
                    String string = TitleTextFieldKeyAdapter.this.textField.getText();
                    if (string.length() > TitleTextFieldKeyAdapter.this.lenght && string.length() >= 3 && (n = TitleTextFieldKeyAdapter.this.fileName.indexOf(string)) != -1) {
                        TitleTextFieldKeyAdapter.this.textField.setText(TitleTextFieldKeyAdapter.this.fileName.substring(n));
                        TitleTextFieldKeyAdapter.this.textField.setSelectionStart(string.length());
                        TitleTextFieldKeyAdapter.this.textField.setSelectionEnd(TitleTextFieldKeyAdapter.this.textField.getText().length());
                    }
                    TitleTextFieldKeyAdapter.this.lenght = string.length();
                }
            });
        }
    }

    private final class GetInsidePictureSwingWorker
    extends SwingWorker<ImageIcon, Void> {
        private final List<AudioFile> audioFiles;

        private GetInsidePictureSwingWorker(List<AudioFile> list) {
            this.audioFiles = list;
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            return AudioFilePictureUtils.getInsidePicture(this.audioFiles.get(0), 400, 400);
        }

        @Override
        protected void done() {
            try {
                if (((Object)EditTagDialogController.this.audioFilesEditing).equals(this.audioFiles)) {
                    ImageIcon imageIcon = (ImageIcon)this.get();
                    EditTagDialogController.this.getEditTagDialog().getCover().setIcon(imageIcon);
                    EditTagDialogController.this.getEditTagDialog().getCoverButton().setEnabled(true);
                    EditTagDialogController.this.getEditTagDialog().getRemoveCoverButton().setEnabled(true);
                    EditTagDialogController.this.getEditTagDialog().getOkButton().setEnabled(true);
                }
            }
            catch (InterruptedException interruptedException) {
                EditTagDialogController.this.getLogger().error("IMAGE       ", interruptedException);
            }
            catch (ExecutionException executionException) {
                EditTagDialogController.this.getLogger().error("IMAGE       ", executionException);
            }
        }
    }
}

