/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class ShowPlayListItemInfoAction
extends AbstractAction {
    private static final long serialVersionUID = -2006569851431046347L;

    ShowPlayListItemInfoAction() {
        super(I18nUtils.getString("INFO"), Images.getImage("info.png"));
        this.putValue("ShortDescription", I18nUtils.getString("INFO_BUTTON_TOOLTIP"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AudioObject audioObject = PlayListHandler.getInstance().getSelectedAudioObjects().get(0);
        GuiHandler.getInstance().showPropertiesDialog(audioObject);
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        return list.size() == 1;
    }
}

