/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.favorites.FavoritesHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class SetFavoriteSongFromNavigatorAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = 4023700964403110853L;

    public SetFavoriteSongFromNavigatorAction() {
        super(I18nUtils.getString("SET_FAVORITE_SONG"), Images.getImage("favorite.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("SET_FAVORITE_SONG"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        FavoritesHandler.getInstance().addFavoriteSongs(list);
        ControllerProxy.getInstance().getNavigationController().refreshTable();
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return true;
    }
}

