/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.SearchDialog;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.internetsearch.Search;
import net.sourceforge.atunes.kernel.modules.internetsearch.SearchFactory;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class SearchArtistAction
extends AbstractAction {
    private static final long serialVersionUID = -4695334457704311336L;

    SearchArtistAction() {
        super(I18nUtils.getString("SEARCH_ARTIST"), Images.getImage("searchArtist.png"));
        this.putValue("ShortDescription", I18nUtils.getString("SEARCH_ARTIST"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getCurrentView().getTree().getSelectionPath();
        if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof Artist) {
            Artist artist = (Artist)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            Search search = SearchFactory.getSearchForName(ApplicationState.getInstance().getDefaultSearch());
            if (search == null) {
                SearchDialog searchDialog = GuiHandler.getInstance().getSearchDialog();
                search = ControllerProxy.getInstance().getNavigationController().openSearchDialog(searchDialog, false);
                if (search != null) {
                    ApplicationState.getInstance().setDefaultSearch(((Object)search).toString());
                }
            }
            if (search != null) {
                DesktopUtils.openSearch(search, artist.getName());
            }
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (defaultMutableTreeNode.getUserObject() instanceof Artist && !((Artist)defaultMutableTreeNode.getUserObject()).isUnknownArtist()) continue;
            return false;
        }
        return true;
    }
}

