/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class SavePlayListAction
extends AbstractAction {
    private static final long serialVersionUID = -303252911138284095L;

    SavePlayListAction() {
        super(StringUtils.getString(I18nUtils.getString("SAVE"), "..."), Images.getImage("save.png"));
        this.putValue("ShortDescription", I18nUtils.getString("SAVE_PLAYLIST_TOOLTIP"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ApplicationState.getInstance().getSavePlaylistPath());
        FileFilter fileFilter = PlayListIO.getPlaylistFileFilter();
        if (GuiHandler.getInstance().showSaveDialog(jFileChooser, fileFilter) == 0) {
            File file = jFileChooser.getSelectedFile();
            ApplicationState.getInstance().setSavePlaylistPath(file.getParentFile().getAbsolutePath());
            if (!file.getName().toUpperCase().endsWith("m3u".toUpperCase())) {
                file = new File(StringUtils.getString(file.getAbsolutePath(), ".", "m3u"));
            }
            if (!file.exists() || file.exists() && GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("OVERWRITE_FILE"), I18nUtils.getString("INFO")) == 0) {
                PlayListIO.write(PlayListHandler.getInstance().getCurrentPlayList(true), file);
            }
        }
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        return !PlayListHandler.getInstance().getCurrentPlayList(true).isEmpty();
    }
}

