/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;
import org.apache.commons.io.FilenameUtils;

public class RenameAudioFileInNavigationTableAction
extends AbstractAction {
    private static final long serialVersionUID = 5607758675193509752L;

    public RenameAudioFileInNavigationTableAction() {
        super(I18nUtils.getString("RENAME_AUDIO_FILE_NAME"), Images.getImage("file_name.png"));
        this.putValue("ShortDescription", I18nUtils.getString("RENAME_AUDIO_FILE_NAME"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        List<AudioFile> list = ControllerProxy.getInstance().getNavigationController().getFilesSelectedInNavigator();
        if (list.size() == 1 && (string = GuiHandler.getInstance().showInputDialog(I18nUtils.getString("RENAME_AUDIO_FILE_NAME"), FilenameUtils.getBaseName((String)list.get(0).getFile().getAbsolutePath()), Images.getImage("file_name.png").getImage())) != null && !string.isEmpty()) {
            RepositoryHandler.getInstance().rename(list.get(0), string);
        }
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return list.size() == 1;
    }
}

