/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.utils.DesktopUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public class OpenFolderAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = 1682289345922375850L;

    OpenFolderAction() {
        super(I18nUtils.getString("OPEN_FOLDER"), Images.getImage("folder.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("OPEN_FOLDER"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        HashSet<File> hashSet = new HashSet<File>();
        for (AudioFile comparable : list) {
            if (hashSet.contains(comparable.getFile().getParentFile())) continue;
            hashSet.add(comparable.getFile().getParentFile());
        }
        for (File file : hashSet) {
            DesktopUtils.openFile(file);
        }
    }
}

