/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.utils.I18nUtils;

public class MarkPodcastListenedAction
extends AbstractAction {
    private static final long serialVersionUID = 2594418895817769179L;

    MarkPodcastListenedAction() {
        super(I18nUtils.getString("MARK_PODCAST_AS_LISTENED"), Images.getImage("markAsRead.png"));
        this.putValue("ShortDescription", I18nUtils.getString("MARK_PODCAST_AS_LISTENED"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = NavigationHandler.getInstance().getView(PodcastNavigationView.class).getTree().getSelectionPath();
        PodcastFeed podcastFeed = (PodcastFeed)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        podcastFeed.markEntriesAsListened();
        NavigationHandler.getInstance().refreshView(PodcastNavigationView.class);
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (bl) {
            return false;
        }
        boolean bl2 = false;
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            List<PodcastFeedEntry> list2 = ((PodcastFeed)defaultMutableTreeNode.getUserObject()).getPodcastFeedEntries();
            for (PodcastFeedEntry podcastFeedEntry : list2) {
                if (podcastFeedEntry.isListened()) continue;
                bl2 = true;
            }
        }
        return bl2;
    }
}

