/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Album;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class CreatePlayListWithSelectedAlbumsAction
extends AbstractActionOverSelectedObjects<AudioObject> {
    private static final long serialVersionUID = -2917908051161952409L;

    CreatePlayListWithSelectedAlbumsAction() {
        super(I18nUtils.getString("SET_ALBUM_AS_PLAYLIST"), Images.getImage("album.png"), AudioObject.class);
        this.putValue("ShortDescription", I18nUtils.getString("ALBUM_BUTTON_TOOLTIP"));
        this.setEnabled(false);
    }

    @Override
    protected void performAction(List<AudioObject> list) {
        Object object;
        Map<String, Artist> map = RepositoryHandler.getInstance().getArtistStructure();
        ArrayList<Album> arrayList = new ArrayList<Album>();
        for (AudioObject object2 : list) {
            Artist artist;
            Album album;
            object = object2.getArtist();
            String string = object2.getAlbum();
            if (!map.containsKey(object) || (album = (artist = map.get(object)).getAlbum(string)) == null || arrayList.contains(album)) continue;
            arrayList.add(album);
        }
        for (Album album : arrayList) {
            object = AudioFile.getAudioObjects(RepositoryHandler.getInstance().getAudioFilesForAlbums(Collections.singletonMap(album.getName(), album)));
            AudioObjectComparator.sort((List<AudioObject>)object);
            PlayListHandler.getInstance().newPlayList(album.getName(), (List<AudioObject>)object);
        }
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        return !list.isEmpty();
    }
}

