/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.tags.writer.ClearTagsProcess;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class ClearTagAction
extends AbstractActionOverSelectedObjects<AudioFile> {
    private static final long serialVersionUID = 4476719536754930347L;
    public static final String PLAYLIST = "PLAYLIST";
    public static final String NAVIGATOR = "NAVIGATOR";

    ClearTagAction() {
        super(I18nUtils.getString("CLEAR_TAG"), Images.getImage("erase.png"), AudioFile.class);
        this.putValue("ShortDescription", I18nUtils.getString("CLEAR_TAG"));
    }

    @Override
    protected void performAction(List<AudioFile> list) {
        new ClearTagsProcess(list).execute();
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        if (NAVIGATOR.equals(this.getActionId())) {
            return !bl && !list.isEmpty();
        }
        return super.isEnabledForNavigationTreeSelection(bl, list);
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        if (NAVIGATOR.equals(this.getActionId())) {
            return !list.isEmpty();
        }
        return super.isEnabledForNavigationTableSelection(list);
    }
}

