/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.kernel.modules.webservices.lyrics.LyricsService;
import net.sourceforge.atunes.utils.I18nUtils;

public class ClearCachesAction
extends AbstractAction {
    private static final long serialVersionUID = 5131926704037915711L;

    public ClearCachesAction() {
        super(I18nUtils.getString("CLEAR_CACHE"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean bl = LastFmService.getInstance().clearCache();
                bl = LyricsService.getInstance().clearCache() || bl;
                return bl;
            }

            @Override
            protected void done() {
                GuiHandler.getInstance().getEditPreferencesDialog().setCursor(Cursor.getDefaultCursor());
                ClearCachesAction.this.setEnabled(true);
            }
        };
        this.setEnabled(false);
        GuiHandler.getInstance().getEditPreferencesDialog().setCursor(Cursor.getPredefinedCursor(3));
        swingWorker.execute();
    }
}

