/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class AddBannedSongInLastFMAction
extends AbstractAction {
    private static final long serialVersionUID = -2687851398606488392L;

    AddBannedSongInLastFMAction() {
        super(I18nUtils.getString("ADD_BANNED_SONG_IN_LASTFM"));
        this.putValue("ShortDescription", I18nUtils.getString("ADD_BANNED_SONG_IN_LASTFM"));
        this.setEnabled(ApplicationState.getInstance().isLastFmEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.banSong(ContextHandler.getInstance().getCurrentAudioObject());
    }

    public void banSong(AudioObject audioObject) {
        this.setEnabled(false);
        new BanSongSwingWorker(audioObject).execute();
    }

    private final class BanSongSwingWorker
    extends SwingWorker<Void, Void> {
        private final AudioObject song;

        private BanSongSwingWorker(AudioObject audioObject) {
            this.song = audioObject;
        }

        @Override
        protected Void doInBackground() throws Exception {
            LastFmService.getInstance().addBannedSong(this.song);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (InterruptedException interruptedException) {
                new Logger().error("CONTEXT     ", interruptedException);
            }
            catch (ExecutionException executionException) {
                new Logger().error("CONTEXT     ", executionException);
            }
            finally {
                AddBannedSongInLastFMAction.this.setEnabled(true);
            }
        }
    }
}

