/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import net.sourceforge.atunes.gui.model.AudioObjectsSource;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.actions.ActionInstance;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;

public final class Actions {
    private static Map<ActionInstance, AbstractAction> actions = new HashMap<ActionInstance, AbstractAction>();

    private Actions() {
    }

    public static <T extends AbstractAction> AbstractAction getAction(Class<T> clazz) {
        return Actions.getAction(clazz, null);
    }

    public static <T extends AbstractAction> AbstractAction getAction(Class<T> clazz, String string) {
        ActionInstance actionInstance = new ActionInstance(clazz, string);
        AbstractAction abstractAction = actions.get(actionInstance);
        if (abstractAction == null) {
            try {
                abstractAction = (AbstractAction)clazz.newInstance();
                abstractAction.setActionId(string);
                abstractAction.setProperties(abstractAction.getProperties(string));
                abstractAction.initialize();
                actions.put(actionInstance, abstractAction);
            }
            catch (InstantiationException instantiationException) {
                new Logger().internalError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                new Logger().internalError(illegalAccessException);
            }
        }
        return abstractAction;
    }

    public static <T extends AbstractActionOverSelectedObjects<? extends AudioObject>> AbstractAction getActionAndBind(Class<T> clazz, Component component, AudioObjectsSource audioObjectsSource) {
        AbstractActionOverSelectedObjects.addRegisteredComponent(component, audioObjectsSource);
        return Actions.getAction(clazz, null);
    }

    public static <T extends AbstractActionOverSelectedObjects<? extends AudioObject>> AbstractAction getActionAndBind(Class<T> clazz, String string, Component component, AudioObjectsSource audioObjectsSource) {
        AbstractActionOverSelectedObjects.addRegisteredComponent(component, audioObjectsSource);
        return Actions.getAction(clazz, string);
    }

    public static JMenuItem getMenuItemForAction(Class<? extends AbstractActionOverSelectedObjects<? extends AudioObject>> clazz, AudioObjectsSource audioObjectsSource) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(Actions.getActionAndBind(clazz, jMenuItem, audioObjectsSource));
        return jMenuItem;
    }

    public static JMenuItem getMenuItemForAction(Class<? extends AbstractActionOverSelectedObjects<? extends AudioObject>> clazz, String string, AudioObjectsSource audioObjectsSource) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(Actions.getActionAndBind(clazz, string, jMenuItem, audioObjectsSource));
        return jMenuItem;
    }
}

