/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.ApplicationArguments;
import net.sourceforge.atunes.Constants;
import net.sourceforge.atunes.gui.ColorDefinitions;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.kernel.AbstractHandler;
import net.sourceforge.atunes.kernel.ApplicationFinishListener;
import net.sourceforge.atunes.kernel.ApplicationStartListener;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.LanguageSelector;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListIO;
import net.sourceforge.atunes.kernel.modules.proxy.Proxy;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.ApplicationStateHandler;
import net.sourceforge.atunes.kernel.modules.webservices.lastfm.LastFmService;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.misc.Timer;
import net.sourceforge.atunes.misc.log.Logger;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class Kernel {
    private static Logger logger;
    private static Kernel instance;
    private static boolean debug;
    private static boolean ignoreLookAndFeel;
    private static boolean noUpdate;
    private static Timer timer;
    private List<AudioObject> commandLinePlayList;
    private List<ApplicationStartListener> startListeners = new ArrayList<ApplicationStartListener>();
    private List<ApplicationFinishListener> finishListeners = new ArrayList<ApplicationFinishListener>();

    protected Kernel() {
    }

    public static Kernel getInstance() {
        return instance;
    }

    public void addStartListener(ApplicationStartListener applicationStartListener) {
        this.startListeners.add(applicationStartListener);
    }

    public void addFinishListener(ApplicationFinishListener applicationFinishListener) {
        this.finishListeners.add(applicationFinishListener);
    }

    public static void startKernel(List<String> list) {
        Kernel.getLogger().debug("START       ", "Starting Kernel");
        timer = new Timer();
        timer.start();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LanguageSelector.setLanguage();
                    Fonts.setFontSmoothing();
                    LookAndFeelSelector.getInstance().setLookAndFeel(ApplicationState.getInstance().getLookAndFeel());
                    Fonts.initializeFonts();
                    ColorDefinitions.initColors();
                    GuiHandler.getInstance().showSplashScreen();
                }
            });
        }
        catch (Exception exception) {
            Kernel.getLogger().error("START       ", exception);
            Kernel.getLogger().error("START       ", exception.getCause());
        }
        instance = new Kernel();
        AbstractHandler.registerHandlers();
        AbstractHandler.initHandlers();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Proxy.initProxy(Proxy.getProxy(ApplicationState.getInstance().getProxy()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        Kernel.getLogger().error("START       ", unknownHostException);
                    }
                    catch (IOException iOException) {
                        Kernel.getLogger().error("START       ", iOException);
                    }
                }
            });
        }
        catch (Exception exception) {
            Kernel.getLogger().error("START       ", exception);
            Kernel.getLogger().error("START       ", exception.getCause());
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (AudioFile.isValidAudioFile(string)) {
                arrayList.add(string);
                continue;
            }
            if (!PlayListIO.isValidPlayList(string)) continue;
            arrayList.addAll(PlayListIO.read(new File(string)));
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    instance.startCreation();
                }
            });
        }
        catch (Exception exception) {
            Kernel.getLogger().error("START       ", exception);
            Kernel.getLogger().error("START       ", exception.getCause());
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    instance.setCommandLinePlayList(PlayListIO.getAudioObjectsFromFileNamesList(arrayList));
                    instance.start();
                }
            });
        }
        catch (Exception exception) {
            Kernel.getLogger().error("START       ", exception);
            Kernel.getLogger().error("START       ", exception.getCause());
        }
    }

    private void callActionsBeforeEnd() {
        for (ApplicationFinishListener applicationFinishListener : this.finishListeners) {
            try {
                if (applicationFinishListener == null) continue;
                applicationFinishListener.applicationFinish();
            }
            catch (Exception exception) {
                Kernel.getLogger().error("END         ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Timer timer = new Timer();
        try {
            timer.start();
            Kernel.getLogger().info("END         ", StringUtils.getString("Closing ", "aTunes", " ", Constants.VERSION.toString()));
            this.callActionsBeforeEnd();
        }
        catch (Throwable throwable) {
            Kernel.getLogger().info("END         ", StringUtils.getString("Application finished (", StringUtils.toString(timer.stop(), 3), " seconds)"));
            Kernel.getLogger().info("END         ", "Goodbye!!");
            System.exit(0);
            throw throwable;
        }
        Kernel.getLogger().info("END         ", StringUtils.getString("Application finished (", StringUtils.toString(timer.stop(), 3), " seconds)"));
        Kernel.getLogger().info("END         ", "Goodbye!!");
        System.exit(0);
    }

    void start() {
        try {
            ApplicationStateHandler.getInstance().applyState();
            GuiHandler.getInstance().setFullFrameVisible(true);
            GuiHandler.getInstance().hideSplashScreen();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Kernel.this.callActionsAfterStart();
                }
            });
            Kernel.getLogger().info("START       ", StringUtils.getString("Application started (", StringUtils.toString(timer.stop(), 3), " seconds)"));
            timer = null;
        }
        catch (Exception exception) {
            Kernel.getLogger().error("KERNEL      ", exception);
        }
    }

    void callActionsAfterStart() {
        for (ApplicationStartListener applicationStartListener : this.startListeners) {
            try {
                if (applicationStartListener == null) continue;
                applicationStartListener.applicationStarted();
            }
            catch (Exception exception) {
                Kernel.getLogger().error("START       ", exception);
            }
        }
        LastFmService.getInstance().submitCacheToLastFm();
    }

    private void startControllers() {
        ControllerProxy.getInstance();
    }

    void startCreation() {
        Kernel.getLogger().debug("START       ", "Starting components");
        this.startVisualization();
        this.startControllers();
        GuiHandler.getInstance().setTitleBar("");
    }

    private void startVisualization() {
        GuiHandler.getInstance().startVisualization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        try {
            this.callActionsBeforeEnd();
            ProcessBuilder processBuilder = new ProcessBuilder(SystemProperties.OS.getLaunchCommand(), ApplicationArguments.getSavedArguments());
            System.out.println(processBuilder.command().toString());
            processBuilder.start();
        }
        catch (IOException iOException) {
            Kernel.getLogger().error("KERNEL      ", iOException);
        }
        finally {
            System.exit(0);
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean isIgnoreLookAndFeel() {
        return ignoreLookAndFeel;
    }

    public static void setIgnoreLookAndFeel(boolean bl) {
        ignoreLookAndFeel = bl;
    }

    public static boolean isNoUpdate() {
        return noUpdate;
    }

    public static void setNoUpdate(boolean bl) {
        noUpdate = bl;
    }

    public void setCommandLinePlayList(List<AudioObject> list) {
        this.commandLinePlayList = list;
    }

    public List<AudioObject> getCommandLinePlayList() {
        return this.commandLinePlayList;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = new Logger();
        }
        return logger;
    }
}

