/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.atunes.gui.views.dialogs.EditTitlesDialog;
import net.sourceforge.atunes.gui.views.panels.AudioObjectPropertiesPanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTreePanel;
import net.sourceforge.atunes.gui.views.panels.PlayListPanel;
import net.sourceforge.atunes.gui.views.panels.PlayListTabPanel;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.actions.EditTagAction;
import net.sourceforge.atunes.kernel.controllers.audioObjectProperties.AudioObjectPropertiesController;
import net.sourceforge.atunes.kernel.controllers.customsearch.CustomSearchController;
import net.sourceforge.atunes.kernel.controllers.editPreferencesDialog.EditPreferencesDialogController;
import net.sourceforge.atunes.kernel.controllers.editTagDialog.EditTagDialogController;
import net.sourceforge.atunes.kernel.controllers.editTitlesDialog.EditTitlesDialogController;
import net.sourceforge.atunes.kernel.controllers.filter.ToolBarFilterController;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.controllers.osd.OSDDialogController;
import net.sourceforge.atunes.kernel.controllers.playList.PlayListController;
import net.sourceforge.atunes.kernel.controllers.playListTab.PlayListTabController;
import net.sourceforge.atunes.kernel.controllers.playerControls.PlayerControlsController;
import net.sourceforge.atunes.kernel.controllers.radioBrowser.RadioBrowserDialogController;
import net.sourceforge.atunes.kernel.controllers.ripcd.RipCdDialogController;
import net.sourceforge.atunes.kernel.controllers.searchResults.SearchResultsController;
import net.sourceforge.atunes.kernel.controllers.stats.StatsDialogController;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.misc.log.Logger;

public final class ControllerProxy {
    private Logger logger;
    private static ControllerProxy instance;
    private NavigationController navigationController;
    private PlayListController playListController;
    private PlayListTabController playListTabController;
    private PlayerControlsController playerControlsController;
    private AudioObjectPropertiesController filePropertiesController;
    private Map<EditTagAction.EditTagSources, EditTagDialogController> editTagDialogControllerMap;
    private StatsDialogController statsDialogController;
    private EditTitlesDialogController editTitlesDialogController;
    private EditPreferencesDialogController editPreferencesDialogController;
    private OSDDialogController osdDialogController;
    private RipCdDialogController ripCdDialogController;
    private CustomSearchController customSearchController;
    private SearchResultsController searchResultsController;
    private RadioBrowserDialogController radioBrowserController;
    private ToolBarFilterController toolBarFilterController;

    private ControllerProxy() {
        this.getLogger().debug("CONTROLLER  ", "Creating ControllerProxy");
        this.getPlayListTabController();
    }

    public static ControllerProxy getInstance() {
        if (instance == null) {
            instance = new ControllerProxy();
        }
        return instance;
    }

    public EditPreferencesDialogController getEditPreferencesDialogController() {
        if (this.editPreferencesDialogController == null) {
            this.editPreferencesDialogController = new EditPreferencesDialogController();
        }
        return this.editPreferencesDialogController;
    }

    public EditTagDialogController getEditTagDialogController(EditTagAction.EditTagSources editTagSources) {
        if (this.editTagDialogControllerMap == null) {
            this.editTagDialogControllerMap = new HashMap<EditTagAction.EditTagSources, EditTagDialogController>();
        }
        if (!this.editTagDialogControllerMap.containsKey((Object)editTagSources)) {
            boolean bl = editTagSources != EditTagAction.EditTagSources.NAVIGATOR;
            this.editTagDialogControllerMap.put(editTagSources, new EditTagDialogController(GuiHandler.getInstance().getEditTagDialog(bl)));
        }
        return this.editTagDialogControllerMap.get((Object)editTagSources);
    }

    public EditTitlesDialogController getEditTitlesDialogController() {
        if (this.editTitlesDialogController == null) {
            EditTitlesDialog editTitlesDialog = GuiHandler.getInstance().getEditTitlesDialog();
            this.editTitlesDialogController = new EditTitlesDialogController(editTitlesDialog);
        }
        return this.editTitlesDialogController;
    }

    public AudioObjectPropertiesController getFilePropertiesController() {
        if (this.filePropertiesController == null) {
            AudioObjectPropertiesPanel audioObjectPropertiesPanel = GuiHandler.getInstance().getPropertiesPanel();
            this.filePropertiesController = new AudioObjectPropertiesController(audioObjectPropertiesPanel);
        }
        return this.filePropertiesController;
    }

    public NavigationController getNavigationController() {
        if (this.navigationController == null) {
            NavigationTreePanel navigationTreePanel = GuiHandler.getInstance().getNavigationTreePanel();
            NavigationTablePanel navigationTablePanel = GuiHandler.getInstance().getNavigationTablePanel();
            this.navigationController = new NavigationController(navigationTreePanel, navigationTablePanel);
        }
        return this.navigationController;
    }

    public OSDDialogController getOSDDialogController() {
        if (this.osdDialogController == null) {
            this.osdDialogController = new OSDDialogController(GuiHandler.getInstance().getOSDDialog());
        }
        return this.osdDialogController;
    }

    public PlayerControlsController getPlayerControlsController() {
        if (this.playerControlsController == null) {
            PlayerControlsPanel playerControlsPanel = null;
            playerControlsPanel = GuiHandler.getInstance().getPlayerControls();
            this.playerControlsController = new PlayerControlsController(playerControlsPanel);
        }
        return this.playerControlsController;
    }

    public PlayListController getPlayListController() {
        if (this.playListController == null) {
            PlayListPanel playListPanel = null;
            playListPanel = GuiHandler.getInstance().getPlayListPanel();
            this.playListController = new PlayListController(playListPanel);
        }
        return this.playListController;
    }

    public PlayListTabController getPlayListTabController() {
        if (this.playListTabController == null) {
            PlayListTabPanel playListTabPanel = GuiHandler.getInstance().getPlayListPanel().getPlayListTabPanel();
            this.playListTabController = new PlayListTabController(playListTabPanel);
        }
        return this.playListTabController;
    }

    public RipCdDialogController getRipCdDialogController() {
        if (this.ripCdDialogController == null) {
            this.ripCdDialogController = new RipCdDialogController(GuiHandler.getInstance().getRipCdDialog());
        }
        return this.ripCdDialogController;
    }

    public StatsDialogController getStatsDialogController() {
        if (this.statsDialogController == null) {
            this.statsDialogController = new StatsDialogController(GuiHandler.getInstance().getStatsDialog());
        }
        return this.statsDialogController;
    }

    public CustomSearchController getCustomSearchController() {
        if (this.customSearchController == null) {
            this.customSearchController = new CustomSearchController(GuiHandler.getInstance().getCustomSearchDialog());
        }
        return this.customSearchController;
    }

    public SearchResultsController getSearchResultsController() {
        if (this.searchResultsController == null) {
            this.searchResultsController = new SearchResultsController(GuiHandler.getInstance().getSearchResultsDialog());
        }
        return this.searchResultsController;
    }

    public RadioBrowserDialogController getRadioBrowserController() {
        if (this.radioBrowserController == null) {
            this.radioBrowserController = new RadioBrowserDialogController(GuiHandler.getInstance().getRadioBrowserDialog());
        }
        return this.radioBrowserController;
    }

    public ToolBarFilterController getToolBarFilterController() {
        if (this.toolBarFilterController == null) {
            this.toolBarFilterController = new ToolBarFilterController(GuiHandler.getInstance().getToolBar().getFilterPanel());
        }
        return this.toolBarFilterController;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

