/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.playerControls.KaraokeButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.MuteButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.NextButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.NormalizationButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PlayPauseButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PreviousButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.RepeatButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.SecondaryControl;
import net.sourceforge.atunes.gui.views.controls.playerControls.ShuffleButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.StopButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.VolumeLevel;
import net.sourceforge.atunes.gui.views.controls.playerControls.VolumeSlider;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PlayerControlsPanel
extends JPanel {
    private static final long serialVersionUID = -8647737014195638177L;
    public static final Dimension DEFAULT_BUTTONS_SIZE = new Dimension(35, 35);
    public static final Dimension PLAY_BUTTON_SIZE = LookAndFeelSelector.getInstance().getCurrentLookAndFeel().isCustomPlayerControlsSupported() ? new Dimension(45, 45) : DEFAULT_BUTTONS_SIZE;
    public static final Dimension PREVIOUS_NEXT_BUTTONS_SIZE = LookAndFeelSelector.getInstance().getCurrentLookAndFeel().isCustomPlayerControlsSupported() ? new Dimension(62, 30) : DEFAULT_BUTTONS_SIZE;
    public static final Dimension STOP_MUTE_BUTTONS_SIZE = LookAndFeelSelector.getInstance().getCurrentLookAndFeel().isCustomPlayerControlsSupported() ? new Dimension(30, 26) : DEFAULT_BUTTONS_SIZE;
    public static final Dimension OTHER_BUTTONS_SIZE = new Dimension(25, 23);
    private static final int PROGRESS_BAR_BOTTOM_MINIMUM_SIZE = 270;
    private static final int PROGRESS_BAR_WIDTH_AT_BOTTOM = 190;
    private static final int PROGRESS_BAR_NO_TICKS_HEIGHT = 26;
    private static final int PROGRESS_BAR_TICKS_HEIGHT = 40;
    private static final int PLAYER_CONTROLS_VERTICAL_MARGIN = 10;
    private ShuffleButton shuffleButton;
    private RepeatButton repeatButton;
    private KaraokeButton karaokeButton;
    private NormalizationButton normalizeButton;
    private PreviousButton previousButton;
    private PlayPauseButton playButton;
    private StopButton stopButton;
    private NextButton nextButton;
    private MuteButton volumeButton;
    private VolumeSlider volumeSlider;
    private VolumeLevel volumeLevel;
    private boolean playing;
    private ProgressSlider progressSlider;
    private JPanel secondaryControls;

    public PlayerControlsPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addContent();
        GuiUtils.applyComponentOrientation(this);
    }

    protected void addContent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.addComponentListener(new BottomProgressSliderPanelComponentAdapter(jPanel2, jPanel));
        this.progressSlider = new ProgressSlider();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(10, PlayerControlsPanel.PLAY_BUTTON_SIZE.height + 10));
        JPanel jPanel4 = this.getMainControlsPanel();
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.getSecondaryControls(), "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)jPanel3, gridBagConstraints);
    }

    public JSlider getProgressBar() {
        return this.progressSlider.getProgressBar();
    }

    public JLabel getRemainingTime() {
        return this.progressSlider.getRemainingTime();
    }

    public JLabel getTime() {
        return this.progressSlider.getTime();
    }

    public JToggleButton getVolumeButton() {
        return this.volumeButton;
    }

    public JSlider getVolumeSlider() {
        return this.volumeSlider;
    }

    public JLabel getVolumeLevel() {
        return this.volumeLevel;
    }

    public NormalizationButton getNormalizeButton() {
        return this.normalizeButton;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    protected static void setButton(JPanel jPanel, JComponent jComponent, GridBagConstraints gridBagConstraints) {
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    public void setPlaying(boolean bl) {
        this.playing = bl;
        this.playButton.setPlaying(bl);
    }

    public void setShowTicksAndLabels(boolean bl) {
        this.getProgressBar().setPaintLabels(bl);
        this.getProgressBar().setPaintTicks(bl);
        this.getProgressBar().setPreferredSize(new Dimension(this.getProgressBar().getPreferredSize().width, bl ? 40 : 26));
    }

    private JPanel getMainControlsPanel() {
        this.previousButton = new PreviousButton(PREVIOUS_NEXT_BUTTONS_SIZE);
        this.playButton = new PlayPauseButton(PLAY_BUTTON_SIZE);
        this.stopButton = new StopButton(STOP_MUTE_BUTTONS_SIZE);
        this.nextButton = new NextButton(PREVIOUS_NEXT_BUTTONS_SIZE);
        this.volumeButton = new MuteButton(STOP_MUTE_BUTTONS_SIZE);
        this.volumeButton.setText("");
        this.volumeSlider = new VolumeSlider();
        this.volumeLevel = new VolumeLevel();
        return PlayerControlsPanel.getPanelWithPlayerControls(this.stopButton, this.previousButton, this.playButton, this.nextButton, this.volumeButton, this.volumeSlider, this.volumeLevel);
    }

    public static JPanel getPanelWithPlayerControls(StopButton stopButton, PreviousButton previousButton, PlayPauseButton playPauseButton, NextButton nextButton, MuteButton muteButton, JSlider jSlider, JLabel jLabel) {
        return LookAndFeelSelector.getInstance().getCurrentLookAndFeel().isCustomPlayerControlsSupported() ? PlayerControlsPanel.getCustomPlayerControls(stopButton, previousButton, playPauseButton, nextButton, muteButton, jSlider, jLabel) : PlayerControlsPanel.getStandardPlayerControls(stopButton, previousButton, playPauseButton, nextButton, muteButton, jSlider, jLabel);
    }

    private static JPanel getCustomPlayerControls(StopButton stopButton, PreviousButton previousButton, PlayPauseButton playPauseButton, NextButton nextButton, MuteButton muteButton, JSlider jSlider, JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        PlayerControlsPanel.setButton(jPanel, stopButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, -6, 0, 0);
        PlayerControlsPanel.setButton(jPanel, previousButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(-1, -16, 0, 0);
        PlayerControlsPanel.setButton(jPanel, playPauseButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, -16, 0, 0);
        PlayerControlsPanel.setButton(jPanel, nextButton, gridBagConstraints);
        if (muteButton != null && jSlider != null && jLabel != null) {
            gridBagConstraints.gridx = 4;
            gridBagConstraints.insets = new Insets(0, -7, 0, 0);
            jPanel.add((Component)muteButton, gridBagConstraints);
            gridBagConstraints.gridx = 5;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            jPanel.add((Component)jSlider, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 5;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(-20, 16, 0, 0);
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        return jPanel;
    }

    private static JPanel getStandardPlayerControls(StopButton stopButton, PreviousButton previousButton, PlayPauseButton playPauseButton, NextButton nextButton, MuteButton muteButton, JSlider jSlider, JLabel jLabel) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        PlayerControlsPanel.setButton(jPanel, stopButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        PlayerControlsPanel.setButton(jPanel, previousButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        PlayerControlsPanel.setButton(jPanel, playPauseButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        PlayerControlsPanel.setButton(jPanel, nextButton, gridBagConstraints);
        if (muteButton != null && jSlider != null && jLabel != null) {
            gridBagConstraints.gridx = 4;
            jPanel.add((Component)muteButton, gridBagConstraints);
            gridBagConstraints.gridx = 5;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jSlider.setMinimumSize(new Dimension(50, 20));
            jPanel.add((Component)jSlider, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 5;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel getSecondaryControls() {
        if (this.secondaryControls == null) {
            this.shuffleButton = new ShuffleButton();
            this.repeatButton = new RepeatButton();
            this.karaokeButton = new KaraokeButton();
            this.normalizeButton = new NormalizationButton();
            this.secondaryControls = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.secondaryControls.add((Component)this.shuffleButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 1, 0, 0);
            this.secondaryControls.add((Component)this.repeatButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.secondaryControls.add((Component)this.karaokeButton, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.secondaryControls.add((Component)this.normalizeButton, gridBagConstraints);
        }
        return this.secondaryControls;
    }

    public void addSecondaryControl(Action action) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.getSecondaryControls().getComponentCount();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        SecondaryControl secondaryControl = new SecondaryControl(action);
        this.getSecondaryControls().add((Component)secondaryControl, gridBagConstraints);
    }

    static class ProgressSlider
    extends JPanel {
        private static final long serialVersionUID = 8921834666233975274L;
        private JLabel time = new JLabel("0:00");
        private JLabel remainingTime;
        private JSlider progressBar;

        ProgressSlider() {
            super(new GridBagLayout());
            this.time.setHorizontalAlignment(0);
            this.time.setPreferredSize(new Dimension(50, 10));
            this.progressBar = new JSlider();
            this.progressBar.setToolTipText(I18nUtils.getString("CLICK_TO_SEEK"));
            this.progressBar.setMinimum(0);
            this.progressBar.setValue(0);
            this.progressBar.setFocusable(false);
            this.progressBar.setPreferredSize(new Dimension(190, 26));
            this.remainingTime = new JLabel("0:00");
            this.remainingTime.setHorizontalAlignment(0);
            this.remainingTime.setPreferredSize(new Dimension(50, 10));
            this.setOpaque(false);
            this.setExpandable(true);
        }

        public JLabel getTime() {
            return this.time;
        }

        public JLabel getRemainingTime() {
            return this.remainingTime;
        }

        public JSlider getProgressBar() {
            return this.progressBar;
        }

        public void setExpandable(boolean bl) {
            this.removeAll();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(1, 10, 0, 0);
            this.add((Component)this.time, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = bl ? 1.0 : 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(1, 5, 0, 5);
            gridBagConstraints.fill = 2;
            this.add((Component)this.progressBar, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(1, 0, 0, 5);
            gridBagConstraints.fill = 0;
            this.add((Component)this.remainingTime, gridBagConstraints);
        }
    }

    private final class BottomProgressSliderPanelComponentAdapter
    extends ComponentAdapter {
        private final JPanel bottomProgressSliderPanel;
        private final JPanel topProgressSliderPanel;
        private Boolean showProgressOnTop = null;

        private BottomProgressSliderPanelComponentAdapter(JPanel jPanel, JPanel jPanel2) {
            this.bottomProgressSliderPanel = jPanel;
            this.topProgressSliderPanel = jPanel2;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            boolean bl;
            boolean bl2 = bl = this.bottomProgressSliderPanel.getWidth() < 270;
            if (this.showProgressOnTop == null || this.showProgressOnTop != bl) {
                if (bl) {
                    this.bottomProgressSliderPanel.remove(PlayerControlsPanel.this.progressSlider);
                    this.topProgressSliderPanel.add((Component)PlayerControlsPanel.this.progressSlider, "Center");
                } else {
                    this.topProgressSliderPanel.remove(PlayerControlsPanel.this.progressSlider);
                    this.bottomProgressSliderPanel.add((Component)PlayerControlsPanel.this.progressSlider, "West");
                }
                PlayerControlsPanel.this.progressSlider.setExpandable(bl);
                this.showProgressOnTop = bl;
            }
        }
    }
}

