/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.panels;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class ButtonTabComponent
extends JPanel {
    private static final long serialVersionUID = 3945896434769821096L;
    private final JTabbedPane pane;
    private final JLabel label;
    private final JButton button = new TabButton();

    public ButtonTabComponent(String string, JTabbedPane jTabbedPane) {
        super(new FlowLayout(0, 0, 0));
        if (jTabbedPane == null) {
            throw new IllegalArgumentException("TabbedPane is null");
        }
        this.pane = jTabbedPane;
        this.setOpaque(false);
        this.label = new JLabel(string);
        this.add(this.label);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(this.button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        GuiUtils.applyComponentOrientation(this);
    }

    public JLabel getLabel() {
        return this.label;
    }

    private final class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -2196619151804754334L;

        public TabButton() {
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText(I18nUtils.getString("CLOSE"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this);
            if (n != -1) {
                PlayListHandler.getInstance().removePlayList(n);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.drawImage(Images.getImage("closeTab.png").getImage(), 0, 0, Images.getImage("closeTab.png").getIconWidth(), Images.getImage("closeTab.png").getIconHeight(), null);
        }

        @Override
        public void updateUI() {
        }
    }
}

