/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class RepositoryPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 3331810461314007217L;
    private JComboBox refreshTime;
    private JCheckBox saveRepositoryAsXml;
    private JTextField commandBeforeAccessRepository;
    private JTextField commandAfterAccessRepository;

    public RepositoryPanel() {
        super(I18nUtils.getString("REPOSITORY"));
        JLabel jLabel = new JLabel(I18nUtils.getString("REPOSITORY_REFRESH_TIME"));
        this.refreshTime = new JComboBox<Integer>(new Integer[]{0, 5, 10, 15, 30, 60});
        this.saveRepositoryAsXml = new JCheckBox(I18nUtils.getString("SAVE_REPOSITORY_AS_XML"));
        JLabel jLabel2 = new JLabel(I18nUtils.getString("COMMAND_BEFORE_REPOSITORY_ACCESS"));
        this.commandBeforeAccessRepository = new CustomTextField(20);
        JLabel jLabel3 = new JLabel(I18nUtils.getString("COMMAND_AFTER_REPOSITORY_ACCESS"));
        this.commandAfterAccessRepository = new CustomTextField(20);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.refreshTime, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.saveRepositoryAsXml, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.commandBeforeAccessRepository, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.commandAfterAccessRepository, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setAutoRepositoryRefreshTime((Integer)this.refreshTime.getSelectedItem());
        applicationState.setSaveRepositoryAsXml(this.saveRepositoryAsXml.isSelected());
        applicationState.setCommandBeforeAccessRepository(this.commandBeforeAccessRepository.getText());
        applicationState.setCommandAfterAccessRepository(this.commandAfterAccessRepository.getText());
        return false;
    }

    private void setRefreshTime(int n) {
        this.refreshTime.setSelectedItem(n);
    }

    private void setSaveRepositoryAsXml(boolean bl) {
        this.saveRepositoryAsXml.setSelected(bl);
    }

    private void setCommandBeforeAccessRepository(String string) {
        this.commandBeforeAccessRepository.setText(string);
    }

    private void setCommandAfterAccessRepository(String string) {
        this.commandAfterAccessRepository.setText(string);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setRefreshTime(applicationState.getAutoRepositoryRefreshTime());
        this.setSaveRepositoryAsXml(applicationState.isSaveRepositoryAsXml());
        this.setCommandBeforeAccessRepository(applicationState.getCommandBeforeAccessRepository());
        this.setCommandAfterAccessRepository(applicationState.getCommandAfterAccessRepository());
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("audioFile_little.png");
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }
}

